/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class RemoveFrequentValues
extends Filter
implements OptionHandler,
UnsupervisedFilter {
    static final long serialVersionUID = -2447432930070059511L;
    private SingleIndex m_AttIndex = new SingleIndex("last");
    protected int m_NumValues = 2;
    protected boolean m_LeastValues = false;
    protected boolean m_Invert = false;
    protected boolean m_ModifyHeader = false;
    protected int[] m_NominalMapping;
    protected HashSet m_Values = null;

    public String globalInfo() {
        return "Determines which values (frequent or infrequent ones) of an (nominal) attribute are retained and filters the instances accordingly. In case of values with the same frequency, they are kept in the way they appear in the original instances object. E.g. if you have the values \"1,2,3,4\" with the frequencies \"10,5,5,3\" and you chose to keep the 2 most common values, the values \"1,2\" would be returned, since the value \"2\" comes before \"3\", even though they have the same frequency.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tChoose attribute to be used for selection.", "C", 1, "-C <num>"));
        vector.addElement(new Option("\tNumber of values to retain for the sepcified attribute, \n\ti.e. the ones with the most instances (default 2).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tInstead of values with the most instances the ones with the \n\tleast are retained.\n", "L", 0, "-L"));
        vector.addElement(new Option("\tWhen selecting on nominal attributes, removes header\n\treferences to excluded values.", "H", 0, "-H"));
        vector.addElement(new Option("\tInvert matching sense.", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndex(string);
        } else {
            this.setAttributeIndex("last");
        }
        String string2 = Utils.getOption('N', stringArray);
        if (string2.length() != 0) {
            this.setNumValues(Integer.parseInt(string2));
        } else {
            this.setNumValues(2);
        }
        this.setUseLeastValues(Utils.getFlag('L', stringArray));
        this.setModifyHeader(Utils.getFlag('H', stringArray));
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getNumValues();
        if (this.getUseLeastValues()) {
            stringArray[n++] = "-H";
        }
        if (this.getModifyHeader()) {
            stringArray[n++] = "-H";
        }
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String attributeIndexTipText() {
        return "Choose attribute to be used for selection (default last).";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    public String numValuesTipText() {
        return "The number of values to retain.";
    }

    public int getNumValues() {
        return this.m_NumValues;
    }

    public void setNumValues(int n) {
        this.m_NumValues = n;
    }

    public String useLeastValuesTipText() {
        return "Retains values with least instance instead of most.";
    }

    public boolean getUseLeastValues() {
        return this.m_LeastValues;
    }

    public void setUseLeastValues(boolean bl) {
        this.m_LeastValues = bl;
    }

    public String modifyHeaderTipText() {
        return "When selecting on nominal attributes, removes header references to excluded values.";
    }

    public boolean getModifyHeader() {
        return this.m_ModifyHeader;
    }

    public void setModifyHeader(boolean bl) {
        this.m_ModifyHeader = bl;
    }

    public String invertSelectionTipText() {
        return "Invert matching sense.";
    }

    public boolean getInvertSelection() {
        return this.m_Invert;
    }

    public void setInvertSelection(boolean bl) {
        this.m_Invert = bl;
    }

    public boolean isNominal() {
        if (this.getInputFormat() == null) {
            return false;
        }
        return this.getInputFormat().attribute(this.m_AttIndex.getIndex()).isNominal();
    }

    public void determineValues(Instances instances) {
        int n;
        int n2;
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        int n3 = this.m_AttIndex.getIndex();
        this.m_Values = new HashSet();
        if (instances == null) {
            return;
        }
        AttributeStats attributeStats = instances.attributeStats(n3);
        int n4 = this.m_Invert ? attributeStats.nominalCounts.length - this.m_NumValues : this.m_NumValues;
        if (n4 < 1) {
            n4 = 1;
        }
        if (n4 > attributeStats.nominalCounts.length) {
            n4 = attributeStats.nominalCounts.length;
        }
        Arrays.sort(attributeStats.nominalCounts);
        if (this.m_LeastValues) {
            n2 = attributeStats.nominalCounts[0];
            n = attributeStats.nominalCounts[n4 - 1];
        } else {
            n2 = attributeStats.nominalCounts[attributeStats.nominalCounts.length - 1 - n4 + 1];
            n = attributeStats.nominalCounts[attributeStats.nominalCounts.length - 1];
        }
        attributeStats = instances.attributeStats(n3);
        for (int i = 0; i < attributeStats.nominalCounts.length; ++i) {
            if (attributeStats.nominalCounts[i] < n2 || attributeStats.nominalCounts[i] > n || this.m_Values.size() >= n4) continue;
            this.m_Values.add(instances.attribute(n3).value(i));
        }
    }

    protected Instances modifyHeader(Instances instances) {
        instances = new Instances(this.getInputFormat(), 0);
        Attribute attribute = instances.attribute(this.m_AttIndex.getIndex());
        int[] nArray = new int[this.m_Values.size()];
        Iterator iterator = this.m_Values.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            nArray[n] = attribute.indexOfValue(iterator.next().toString());
            ++n;
        }
        FastVector fastVector = new FastVector();
        for (n = 0; n < nArray.length; ++n) {
            fastVector.addElement(attribute.value(nArray[n]));
        }
        instances.deleteAttributeAt(this.m_AttIndex.getIndex());
        instances.insertAttributeAt(new Attribute(attribute.name(), fastVector), this.m_AttIndex.getIndex());
        this.m_NominalMapping = new int[attribute.numValues()];
        for (n = 0; n < this.m_NominalMapping.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                this.m_NominalMapping[n] = i;
                bl = true;
                break;
            }
            if (bl) continue;
            this.m_NominalMapping[n] = -1;
        }
        return instances;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        if (!this.isNominal()) {
            throw new UnsupportedAttributeTypeException("Can only handle nominal attributes.");
        }
        this.m_Values = null;
        return false;
    }

    protected void setOutputFormat() {
        if (this.m_Values == null) {
            this.setOutputFormat(null);
            return;
        }
        Instances instances = this.getModifyHeader() ? this.modifyHeader(this.getInputFormat()) : new Instances(this.getInputFormat(), 0);
        this.setOutputFormat(instances);
        for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
            Instance instance = this.getInputFormat().instance(i);
            if (!this.m_Values.contains(instance.stringValue(this.m_AttIndex.getIndex()))) continue;
            if (this.getModifyHeader()) {
                instance.setValue(this.m_AttIndex.getIndex(), (double)this.m_NominalMapping[(int)instance.value(this.m_AttIndex.getIndex())]);
            }
            this.push(instance);
        }
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Values == null) {
            this.determineValues(this.getInputFormat());
            this.setOutputFormat();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public static void main(String[] stringArray) {
        RemoveFrequentValues.runFilter(new RemoveFrequentValues(), stringArray);
    }
}

