/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;

public class PlaceNode1
implements NodePlace {
    private double[] m_levels;
    private int m_noLevels;
    private int[] m_levelNode;
    private double m_yRatio;

    public void place(Node node) {
        int n;
        this.m_noLevels = Node.getHeight(node, 0) + 1;
        this.m_yRatio = 1.0 / (double)this.m_noLevels;
        this.m_levels = new double[this.m_noLevels];
        this.m_levelNode = new int[this.m_noLevels];
        for (n = 0; n < this.m_noLevels; ++n) {
            this.m_levels[n] = 1.0;
            this.m_levelNode[n] = 0;
        }
        this.setNumOfNodes(node, 0);
        for (n = 0; n < this.m_noLevels; ++n) {
            this.m_levels[n] = 1.0 / this.m_levels[n];
        }
        this.placer(node, 0);
    }

    private void setNumOfNodes(Node node, int n) {
        Edge edge;
        int n2 = ++n;
        this.m_levels[n2] = this.m_levels[n2] + 1.0;
        int n3 = 0;
        while ((edge = node.getChild(n3)) != null && node.getCVisible()) {
            this.setNumOfNodes(edge.getTarget(), n);
            ++n3;
        }
    }

    private void placer(Node node, int n) {
        Edge edge;
        int n2 = ++n;
        this.m_levelNode[n2] = this.m_levelNode[n2] + 1;
        node.setCenter((double)this.m_levelNode[n] * this.m_levels[n]);
        node.setTop((double)n * this.m_yRatio);
        int n3 = 0;
        while ((edge = node.getChild(n3)) != null && node.getCVisible()) {
            this.placer(edge.getTarget(), n);
            ++n3;
        }
    }
}

