% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_apply_wyearly.R
\name{rvn_apply_wyearly}
\alias{rvn_apply_wyearly}
\title{Apply function for water year}
\usage{
rvn_apply_wyearly(x, FUN, ..., mm = 9, dd = 30)
}
\arguments{
\item{x}{xts vector to calculate FUN for}

\item{FUN}{the function to be applied}

\item{...}{optional arguments to FUN}

\item{mm}{month of water year ending (default 9)}

\item{dd}{day of water year ending (default 30)}
}
\description{
rvn_apply_wyearly calculates a function FUN for the periods defined by the water
year, similar to other functions of the form apply.<time period>, for
example apply.daily, apply.monthly, etc.
}
\details{
The default water year start is
October 1st, but may be adjusted with the mm and dd arguments. The values for
mm and dd indicate the end of the water year period (i.e. mm=9 and dd=30 indicates
a new water year on Oct 1).

Note that if using \code{FUN=mean}, please use \code{FUN=colMeans} instead.
}
\examples{
# use sample forcing data (or use forcings_read to read in ForcingFunctions.csv)
ff <- system.file("extdata","run1_ForcingFunctions.csv", package = "RavenR")
rvn_forcing_data <- RavenR::rvn_forcings_read(ff)

# apply mean (with colMeans) as FUN to daily average temperature
rvn_apply_wyearly(rvn_forcing_data$forcings$temp_daily_ave,colMeans,na.rm=TRUE)

# apply mean as FUN to all forcings
rvn_apply_wyearly(rvn_forcing_data$forcings,colMeans,na.rm=TRUE)

# apply maximum via RavenR::cmax as FUN to all forcings (takes the max in each column)
## note that the base::max will not work properly here
rvn_apply_wyearly(rvn_forcing_data$forcings,cmax,na.rm=TRUE)

# apply to Australian water year (July 1)
rvn_apply_wyearly(rvn_forcing_data$forcings,cmax,na.rm=TRUE, mm=6, dd=30)

}
\seealso{
\code{\link{rvn_wyear_indices}} for obtaining endpoints in the water year
}
