/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetFactHandlesCommand
implements GenericCommand<Collection<FactHandle>> {
    private transient ObjectFilter filter = null;
    @XmlAttribute
    private boolean disconnected = false;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public GetFactHandlesCommand() {
    }

    public GetFactHandlesCommand(ObjectFilter filter) {
        this.filter = filter;
    }

    public GetFactHandlesCommand(ObjectFilter filter, boolean disconnected) {
        this.filter = filter;
        this.disconnected = disconnected;
    }

    public GetFactHandlesCommand(boolean disconnected) {
        this.disconnected = disconnected;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    @Override
    public Collection<FactHandle> execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        ArrayList<FactHandle> disconnectedFactHandles = new ArrayList<FactHandle>();
        if (this.filter != null) {
            Collection factHandles = ksession.getFactHandles(this.filter);
            if (factHandles != null && this.disconnected) {
                for (InternalFactHandle factHandle : factHandles) {
                    InternalFactHandle handle = factHandle.clone();
                    handle.disconnect();
                    disconnectedFactHandles.add(handle);
                }
                if (this.outIdentifier != null) {
                    ((InternalWorkingMemory)ksession).getExecutionResult().getResults().put(this.outIdentifier, disconnectedFactHandles);
                }
                return disconnectedFactHandles;
            }
            Collection ksessionFactHandles = ksession.getFactHandles(this.filter);
            if (this.outIdentifier != null) {
                ((InternalWorkingMemory)ksession).getExecutionResult().getResults().put(this.outIdentifier, new ArrayList(ksessionFactHandles));
            }
            return ksessionFactHandles;
        }
        Collection factHandles = ksession.getFactHandles();
        if (factHandles != null && this.disconnected) {
            for (InternalFactHandle factHandle : factHandles) {
                InternalFactHandle handle = factHandle.clone();
                handle.disconnect();
                disconnectedFactHandles.add(handle);
            }
            if (this.outIdentifier != null) {
                ((InternalWorkingMemory)ksession).getExecutionResult().getResults().put(this.outIdentifier, disconnectedFactHandles);
            }
            return disconnectedFactHandles;
        }
        Collection ksessionFactHandles = ksession.getFactHandles();
        if (this.outIdentifier != null) {
            ((InternalWorkingMemory)ksession).getExecutionResult().getResults().put(this.outIdentifier, new ArrayList(ksessionFactHandles));
        }
        return ksessionFactHandles;
    }

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public String toString() {
        if (this.filter != null) {
            return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), null, ObjectStoreWrapper.FACT_HANDLE )";
        }
        return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), filter, ObjectStoreWrapper.FACT_HANDLE )";
    }
}

