/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.core.base.TraitHelper;
import org.drools.core.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.factmodel.traits.TraitFactory;
import org.drools.core.factmodel.traits.TraitTypeEnum;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.StringUtils;

@XmlRootElement(name="fact-handle")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultFactHandle
extends AbstractBaseLinkedListNode<DefaultFactHandle>
implements InternalFactHandle {
    private static final long serialVersionUID = 510L;
    static final String FACT_FORMAT_VERSION = "0";
    private int id;
    private long recency;
    private Object object;
    private EqualityKey key;
    private int objectHashCode;
    private int identityHashCode;
    private RightTuple firstRightTuple;
    private RightTuple lastRightTuple;
    private LeftTuple firstLeftTuple;
    private LeftTuple lastLeftTuple;
    private InternalWorkingMemoryEntryPoint entryPoint;
    private boolean disconnected;
    private TraitTypeEnum traitType;
    private boolean valid = true;
    private boolean negated;
    private String objectClassName;

    public DefaultFactHandle() {
    }

    public DefaultFactHandle(int id, Object object) {
        this(id, object, id, null, false);
    }

    public DefaultFactHandle(int id, Object object, long recency, InternalWorkingMemoryEntryPoint wmEntryPoint) {
        this(id, DefaultFactHandle.determineIdentityHashCode(object), object, recency, wmEntryPoint, false);
    }

    public DefaultFactHandle(int id, Object object, long recency, InternalWorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        this(id, DefaultFactHandle.determineIdentityHashCode(object), object, recency, wmEntryPoint, isTraitOrTraitable);
    }

    public DefaultFactHandle(int id, int identityHashCode, Object object, long recency, InternalWorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        this.id = id;
        this.entryPoint = wmEntryPoint;
        this.recency = recency;
        this.setObject(object);
        this.identityHashCode = identityHashCode;
        this.traitType = isTraitOrTraitable ? this.determineTraitType() : TraitTypeEnum.NON_TRAIT;
    }

    public DefaultFactHandle(int id, String wmEntryPointId, int identityHashCode, int objectHashCode, long recency, Object object) {
        this.id = id;
        this.entryPoint = wmEntryPointId == null ? null : new DisconnectedWorkingMemoryEntryPoint(wmEntryPointId);
        this.recency = recency;
        this.setObject(object);
        this.identityHashCode = identityHashCode;
        this.objectHashCode = objectHashCode;
        this.disconnected = true;
        this.traitType = TraitTypeEnum.NON_TRAIT;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DefaultFactHandle)) {
            return false;
        }
        return this.id == ((DefaultFactHandle)object).id;
    }

    @Override
    public void disconnect() {
        this.key = null;
        this.firstLeftTuple = null;
        this.firstRightTuple = null;
        this.lastLeftTuple = null;
        this.lastRightTuple = null;
        this.entryPoint = this.entryPoint == null ? null : new DisconnectedWorkingMemoryEntryPoint(this.entryPoint.getEntryPointId());
        this.disconnected = true;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    @Override
    public <K> K as(Class<K> klass) throws ClassCastException {
        K k;
        if (klass.isAssignableFrom(this.object.getClass())) {
            return (K)this.object;
        }
        if (this.isTraitOrTraitable() && (k = TraitHelper.extractTrait(this, klass)) != null) {
            return k;
        }
        throw new ClassCastException("The Handle's Object can't be cast to " + klass);
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    @Override
    public int getObjectHashCode() {
        return this.objectHashCode;
    }

    @Override
    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public static int determineIdentityHashCode(Object object) {
        return System.identityHashCode(object);
    }

    protected void setObjectHashCode(int hashCode) {
        this.objectHashCode = hashCode;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public final String toExternalForm() {
        return this.getFormatVersion() + ":" + this.id + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency() + ":" + (this.entryPoint != null ? this.entryPoint.getEntryPointId() : "null") + ":" + this.traitType.name() + ":" + this.objectClassName;
    }

    protected String getFormatVersion() {
        return FACT_FORMAT_VERSION;
    }

    @XmlAttribute(name="external-form")
    public String getExternalForm() {
        return this.toExternalForm();
    }

    public void setExternalForm(String externalForm) {
        DefaultFactHandle.populateFactHandleFromExternalForm(externalForm, this);
    }

    public String toString() {
        return "[fact " + this.toExternalForm() + ":" + this.object + "]";
    }

    @Override
    public long getRecency() {
        return this.recency;
    }

    @Override
    public void setRecency(long recency) {
        this.recency = recency;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public String getObjectClassName() {
        return this.objectClassName;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
        if (object != null) {
            this.objectClassName = object.getClass().getName();
            this.objectHashCode = object.hashCode();
        } else {
            this.objectHashCode = 0;
        }
        if (this.isTraitOrTraitable()) {
            TraitTypeEnum newType = this.determineTraitType();
            if (this.traitType != TraitTypeEnum.LEGACY_TRAITABLE || newType == TraitTypeEnum.LEGACY_TRAITABLE) {
                this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(object);
            }
            this.traitType = newType;
        } else {
            this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(object);
        }
    }

    @Override
    public EqualityKey getEqualityKey() {
        return this.key;
    }

    @Override
    public void setEqualityKey(EqualityKey key) {
        this.key = key;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isTraitOrTraitable() {
        return this.traitType != TraitTypeEnum.NON_TRAIT;
    }

    @Override
    public RightTuple getFirstRightTuple() {
        return this.firstRightTuple;
    }

    protected void setFirstRightTuple(RightTuple firstRightTuple) {
        this.firstRightTuple = firstRightTuple;
    }

    @Override
    public RightTuple getLastRightTuple() {
        return this.lastRightTuple;
    }

    protected void setLastRightTuple(RightTuple lastRightTuple) {
        this.lastRightTuple = lastRightTuple;
    }

    @Override
    public void setFirstLeftTuple(LeftTuple firstLeftTuple) {
        this.firstLeftTuple = firstLeftTuple;
    }

    @Override
    public LeftTuple getFirstLeftTuple() {
        return this.firstLeftTuple;
    }

    @Override
    public void setLastLeftTuple(LeftTuple lastLeftTuple) {
        this.lastLeftTuple = lastLeftTuple;
    }

    @Override
    public LeftTuple getLastLeftTuple() {
        return this.lastLeftTuple;
    }

    @Override
    public InternalWorkingMemoryEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public void setEntryPoint(InternalWorkingMemoryEntryPoint sourceNode) {
        this.entryPoint = sourceNode;
    }

    @Override
    public void addFirstLeftTuple(LeftTuple leftTuple) {
        LeftTuple previous = this.getFirstLeftTuple();
        if (previous == null) {
            leftTuple.setHandlePrevious(null);
            leftTuple.setHandleNext(null);
            this.setFirstLeftTuple(leftTuple);
            this.setLastLeftTuple(leftTuple);
        } else {
            leftTuple.setHandlePrevious(null);
            leftTuple.setHandleNext(previous);
            previous.setHandlePrevious(leftTuple);
            this.setFirstLeftTuple(leftTuple);
        }
    }

    @Override
    public void addLastLeftTuple(LeftTuple leftTuple) {
        LeftTuple previous = this.getLastLeftTuple();
        if (previous == null) {
            leftTuple.setHandlePrevious(null);
            leftTuple.setHandleNext(null);
            this.setFirstLeftTuple(leftTuple);
            this.setLastLeftTuple(leftTuple);
        } else {
            leftTuple.setHandlePrevious(previous);
            leftTuple.setHandleNext(null);
            previous.setHandleNext(leftTuple);
            this.setLastLeftTuple(leftTuple);
        }
    }

    @Override
    public void addTupleInPosition(Tuple tuple) {
        Tuple previous;
        boolean left = tuple instanceof LeftTuple;
        ObjectTypeNode.Id otnId = tuple.getInputOtnId();
        if (otnId == null) {
            this.addLastTuple(tuple, left);
            return;
        }
        Tuple tuple2 = previous = left ? this.getLastLeftTuple() : this.getLastRightTuple();
        if (previous == null) {
            tuple.setHandlePrevious(null);
            tuple.setHandleNext(null);
            this.setFirstTuple(tuple, left);
            this.setLastTuple(tuple, left);
            return;
        }
        if (previous.getTupleSink() == null || !otnId.before(previous.getInputOtnId())) {
            tuple.setHandlePrevious(previous);
            tuple.setHandleNext(null);
            previous.setHandleNext(tuple);
            this.setLastTuple(tuple, left);
            return;
        }
        Tuple next = previous;
        for (previous = previous.getHandlePrevious(); previous != null && otnId.before(previous.getInputOtnId()); previous = previous.getHandlePrevious()) {
            next = previous;
        }
        tuple.setHandleNext(next);
        next.setHandlePrevious(tuple);
        tuple.setHandlePrevious(previous);
        if (previous != null) {
            previous.setHandleNext(tuple);
        } else {
            this.setFirstTuple(tuple, left);
        }
    }

    private void addLastTuple(Tuple tuple, boolean left) {
        if (left) {
            this.addLastLeftTuple((LeftTuple)tuple);
        } else {
            this.addLastRightTuple((RightTuple)tuple);
        }
    }

    private void setFirstTuple(Tuple tuple, boolean left) {
        if (left) {
            this.setFirstLeftTuple((LeftTuple)tuple);
        } else {
            this.setFirstRightTuple((RightTuple)tuple);
        }
    }

    private void setLastTuple(Tuple tuple, boolean left) {
        if (left) {
            this.setLastLeftTuple((LeftTuple)tuple);
        } else {
            this.setLastRightTuple((RightTuple)tuple);
        }
    }

    @Override
    public void removeLeftTuple(LeftTuple leftTuple) {
        LeftTuple previous = (LeftTuple)leftTuple.getHandlePrevious();
        LeftTuple next = (LeftTuple)leftTuple.getHandleNext();
        if (previous != null && next != null) {
            previous.setHandleNext(next);
            next.setHandlePrevious(previous);
        } else if (next != null) {
            next.setHandlePrevious(null);
            this.setFirstLeftTuple(next);
        } else if (previous != null) {
            previous.setHandleNext(null);
            this.setLastLeftTuple(previous);
        } else {
            this.setFirstLeftTuple(null);
            this.setLastLeftTuple(null);
        }
        leftTuple.setHandlePrevious(null);
        leftTuple.setHandleNext(null);
    }

    @Override
    public void addFirstRightTuple(RightTuple rightTuple) {
        RightTuple previousFirst = this.getFirstRightTuple();
        this.setFirstRightTuple(rightTuple);
        if (previousFirst == null) {
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(null);
            this.setLastRightTuple(rightTuple);
        } else {
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(previousFirst);
            previousFirst.setHandlePrevious(rightTuple);
        }
    }

    @Override
    public void addLastRightTuple(RightTuple rightTuple) {
        RightTuple previousLast = this.getLastRightTuple();
        if (previousLast == null) {
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(null);
            this.setFirstRightTuple(rightTuple);
            this.setLastRightTuple(rightTuple);
        } else {
            rightTuple.setHandlePrevious(previousLast);
            rightTuple.setHandleNext(null);
            previousLast.setHandleNext(rightTuple);
            this.setLastRightTuple(rightTuple);
        }
    }

    @Override
    public void removeRightTuple(RightTuple rightTuple) {
        RightTuple previous = (RightTuple)rightTuple.getHandlePrevious();
        RightTuple next = (RightTuple)rightTuple.getHandleNext();
        if (previous != null && next != null) {
            previous.setHandleNext(next);
            next.setHandlePrevious(previous);
        } else if (next != null) {
            next.setHandlePrevious(null);
            this.setFirstRightTuple(next);
        } else if (previous != null) {
            previous.setHandleNext(null);
            this.setLastRightTuple(previous);
        } else {
            this.setFirstRightTuple(null);
            this.setLastRightTuple(null);
        }
        rightTuple.setHandlePrevious(null);
        rightTuple.setHandleNext(null);
    }

    @Override
    public void clearLeftTuples() {
        this.setFirstLeftTuple(null);
        this.setLastLeftTuple(null);
    }

    @Override
    public void clearRightTuples() {
        this.setFirstRightTuple(null);
        this.setLastRightTuple(null);
    }

    @Override
    public DefaultFactHandle quickClone() {
        DefaultFactHandle clone = new DefaultFactHandle(this.id, this.object, this.recency, this.entryPoint);
        clone.key = this.key;
        clone.objectHashCode = this.objectHashCode;
        clone.identityHashCode = this.identityHashCode;
        clone.disconnected = this.disconnected;
        clone.traitType = this.traitType;
        clone.negated = this.negated;
        return clone;
    }

    public void quickCloneUpdate(DefaultFactHandle clone) {
        clone.object = this.object;
        clone.recency = this.recency;
        clone.key = this.key;
        clone.objectHashCode = this.objectHashCode;
        clone.identityHashCode = this.identityHashCode;
        clone.traitType = this.traitType;
        clone.disconnected = this.disconnected;
        clone.negated = this.negated;
    }

    @Override
    public DefaultFactHandle clone() {
        DefaultFactHandle clone = new DefaultFactHandle(this.id, this.object, this.recency, this.entryPoint);
        clone.key = this.key;
        clone.firstLeftTuple = this.firstLeftTuple;
        clone.lastLeftTuple = this.lastLeftTuple;
        clone.firstRightTuple = this.firstRightTuple;
        clone.lastRightTuple = this.lastRightTuple;
        clone.objectHashCode = this.objectHashCode;
        clone.identityHashCode = System.identityHashCode(clone.object);
        clone.disconnected = this.disconnected;
        clone.traitType = this.traitType;
        clone.negated = this.negated;
        return clone;
    }

    private Object toExternalString() {
        return "[F:" + this.getId() + " first=" + System.identityHashCode(this.firstLeftTuple) + " last=" + System.identityHashCode(this.lastLeftTuple) + " ]";
    }

    public static DefaultFactHandle createFromExternalFormat(String externalFormat) {
        DefaultFactHandle handle;
        String[] elements = DefaultFactHandle.splitExternalForm(externalFormat);
        if (FACT_FORMAT_VERSION.equals(elements[0])) {
            handle = new DefaultFactHandle();
        } else if ("5".equals(elements[0])) {
            handle = new EventFactHandle();
        } else {
            throw new RuntimeException("Unknown fact handle version format: " + elements[0]);
        }
        DefaultFactHandle.populateFactHandleFromExternalForm(elements, handle);
        return handle;
    }

    private static String[] splitExternalForm(String externalFormat) {
        String[] elements = externalFormat.split(":");
        if (elements.length < 6) {
            throw new IllegalArgumentException("externalFormat did not have enough elements [" + externalFormat + "]");
        }
        return elements;
    }

    private static void populateFactHandleFromExternalForm(String externalFormat, DefaultFactHandle handle) {
        DefaultFactHandle.populateFactHandleFromExternalForm(DefaultFactHandle.splitExternalForm(externalFormat), handle);
    }

    private static void populateFactHandleFromExternalForm(String[] elements, DefaultFactHandle handle) {
        handle.id = Integer.parseInt(elements[1]);
        handle.identityHashCode = Integer.parseInt(elements[2]);
        handle.objectHashCode = Integer.parseInt(elements[3]);
        handle.recency = Long.parseLong(elements[4]);
        handle.entryPoint = StringUtils.isEmpty(elements[5]) || "null".equals(elements[5].trim()) ? null : new DisconnectedWorkingMemoryEntryPoint(elements[5].trim());
        handle.disconnected = true;
        handle.traitType = elements.length > 6 ? TraitTypeEnum.valueOf(elements[6]) : TraitTypeEnum.NON_TRAIT;
        handle.objectClassName = elements.length > 7 ? elements[7] : null;
    }

    private TraitTypeEnum determineTraitType() {
        if (this.isTraitOrTraitable()) {
            return TraitFactory.determineTraitType(this.object);
        }
        return TraitTypeEnum.NON_TRAIT;
    }

    @Override
    public boolean isTraitable() {
        return this.traitType == TraitTypeEnum.TRAITABLE || this.traitType == TraitTypeEnum.WRAPPED_TRAITABLE;
    }

    @Override
    public boolean isTraiting() {
        return this.traitType == TraitTypeEnum.TRAIT;
    }

    @Override
    public TraitTypeEnum getTraitType() {
        return this.traitType;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public boolean isPendingRemoveFromStore() {
        return false;
    }
}

