/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.docx4j.utils.AbstractTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundTraversalUtilVisitorCallback
extends AbstractTraversalUtilVisitorCallback {
    Map<Class, List<TraversalUtilVisitor>> visitorMap = null;

    public CompoundTraversalUtilVisitorCallback(List<TraversalUtilVisitor> visitorList) {
        this.visitorMap = this.setupTraversalVistorMap(visitorList);
    }

    protected Map<Class, List<TraversalUtilVisitor>> setupTraversalVistorMap(List<TraversalUtilVisitor> visitorList) {
        HashMap<Class, List<TraversalUtilVisitor>> ret = new HashMap<Class, List<TraversalUtilVisitor>>();
        Class visitorClass = null;
        LinkedList<TraversalUtilVisitor> classVisitorList = null;
        for (TraversalUtilVisitor visitor : visitorList) {
            visitorClass = this.findClassParameter(visitor.getClass());
            if (visitorClass == null) {
                throw new IllegalArgumentException("Can't identify the parameter class of the visitor " + visitor.getClass().getName());
            }
            classVisitorList = (LinkedList<TraversalUtilVisitor>)ret.get(visitorClass);
            if (classVisitorList == null) {
                classVisitorList = new LinkedList<TraversalUtilVisitor>();
                ret.put(visitorClass, classVisitorList);
            }
            classVisitorList.add(visitor);
        }
        return ret;
    }

    @Override
    protected List<Object> apply(Object child, Object parent, List siblings) {
        for (Map.Entry<Class, List<TraversalUtilVisitor>> entrySet : this.visitorMap.entrySet()) {
            List<TraversalUtilVisitor> classVisitorList;
            Class currentClass = entrySet.getKey();
            if (!currentClass.isAssignableFrom(child.getClass()) || null == (classVisitorList = entrySet.getValue())) continue;
            for (TraversalUtilVisitor visitor : classVisitorList) {
                visitor.apply(child, parent, siblings);
            }
        }
        return null;
    }
}

