% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PyFunctions.R
\name{pyUploadCsv}
\alias{pyUploadCsv}
\title{Py Upload CSV}
\usage{
pyUploadCsv(connection, table, filepath, schema, disableConstraints = FALSE)
}
\arguments{
\item{connection}{DatabaseConnector connection instance}

\item{table}{Table in database}

\item{filepath}{path to csv}

\item{schema}{database schema containing table reference}

\item{disableConstraints}{(not reccomended) disable constraints prior to upload to speed up process}
}
\description{
Wrapper to python function to upload a csv using Postgres Copy functionality
}
\examples{
\dontrun{
connection <- DabaseConnector::connect(
  dbms = "postgreql",
  server = "myserver.com",
  port = 5432,
  password = "s",
  user = "me",
  database = "some_db"
)
ResultModelManager::pyUploadCsv(connection,
  table = "my_table",
  filepath = "my_massive_csv.csv",
  schema = "my_schema"
)
}
}
