% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropTip.R
\name{dropTip}
\alias{dropTip}
\title{dropTip}
\usage{
dropTip(tree, tips)
}
\arguments{
\item{tree}{(list of lists of treedata objects; no default) Name of a list of
lists of treedata objects, such as produced by readTrees().}

\item{tips}{(character or numeric, no default) The tips(s) to drop. Either a
single taxon name or node number or vector of such.}
}
\value{
returns a list of list of treedata objects, with the modified tips.
}
\description{
Drop one or multiple tips from your tree
}
\details{
Modifies a tree object (in RevGadget's format) by dropping one or more tips
from the tree and from any associated data. Wrapper for treeio::drop.tip().
}
\examples{

file <- system.file("extdata",
                    "sub_models/primates_cytb_GTR_MAP.tre",
                    package="RevGadgets")
tree <- readTrees(paths = file)
# reroot tree, then drop the tip
tree <- rerootPhylo(tree = tree, outgroup = "Galeopterus_variegatus")
tree_dropped <- dropTip(tree, "Otolemur_crassicaudatus")


}
\seealso{
treeio: \link[treeio]{drop.tip} and ape: \link[ape]{drop.tip}.
}
