% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.rfpred.cate.R
\name{mice.impute.rfpred.cate}
\alias{mice.impute.rfpred.cate}
\title{Univariate sampler function for categorical variables for prediction-based
imputation, using predicted probabilities of random forest}
\usage{
mice.impute.rfpred.cate(
  y,
  ry,
  x,
  wy = NULL,
  num.trees.cate = 10,
  use.pred.prob.cate = TRUE,
  forest.vote.cate = FALSE,
  pre.boot = TRUE,
  num.threads = NULL,
  ...
)
}
\arguments{
\item{y}{Vector to be imputed.}

\item{ry}{Logical vector of length \code{length(y)} indicating the
the subset \code{y[ry]} of elements in \code{y} to which the imputation
model is fitted. The \code{ry} generally distinguishes the observed
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{num.trees.cate}{Number of trees to build for categorical variables,
default to \code{10}.}

\item{use.pred.prob.cate}{Logical, \code{TRUE} for assigning categories based
on predicted probabilities, \code{FALSE} for imputation based on random draws
from predictions of classification trees, default to \code{TRUE}. Note that
if \code{forest.vote.cate = TRUE}, then this option is invalid.}

\item{forest.vote.cate}{Logical, \code{TRUE} for assigning categories based
on majority votes of random forests, \code{FALSE} for imputation based on
control of option \code{use.pred.prob.cate}, default to \code{FALSE}.}

\item{pre.boot}{Perform bootstrap prior to imputation to get 'proper'
multiple imputation, i.e. accommodating sampling variation in estimating
population regression parameters (see Shah et al. 2014).
It should be noted that if \code{TRUE}, this option is in effect even if the
number of trees is set to one.}

\item{num.threads}{Number of threads for parallel computing. The default is
\code{num.threads = NULL} and all the processors available can be used.}

\item{...}{Other arguments to pass down.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length
\code{sum(wy)}.
}
\description{
Please note that functions with names starting with "mice.impute" are
exported to be visible for the mice sampler functions. Please do not call
these functions directly unless you know exactly what you are doing.

For categorical variables only.

Part of project \code{RfEmpImp}, the function \code{mice.impute.rfpred.cate}
is for categorical variables, performing imputation based on predicted
probabilities for the categories.
}
\details{
\code{RfEmpImp} Imputation sampler for: categorical variables based on
predicted probabilities.
}
\examples{
# Prepare data
mtcars.catmcar <- mtcars
mtcars.catmcar[, c("gear", "carb")] <-
    gen.mcar(mtcars.catmcar[, c("gear", "carb")], warn.empty.row = FALSE)
mtcars.catmcar <- conv.factor(mtcars.catmcar, c("gear", "carb"))
# Perform imputation
impObj <- mice(mtcars.catmcar, method = "rfpred.cate", m = 5, maxit = 5,
maxcor = 1.0, eps = 0,
remove.collinear = FALSE, remove.constant = FALSE,
printFlag = FALSE)

}
\references{
Hong, Shangzhi, et al. "Multiple imputation using chained random forests."
Preprint, submitted April 30, 2020. https://arxiv.org/abs/2004.14823.

Shah, Anoop D., et al. "Comparison of random forest and parametric
imputation models for imputing missing data using MICE: a CALIBER study."
American journal of epidemiology 179.6 (2014): 764-774.

Malley, James D., et al. "Probability machines." Methods of information
in medicine 51.01 (2012): 74-81.
}
\author{
Shangzhi Hong
}
