% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_SP.R
\name{SP_production}
\alias{SP_production}
\title{Find the production parameter based on depletion that produces MSY}
\usage{
SP_production(depletion, figure = TRUE)
}
\arguments{
\item{depletion}{The hypothesized depletion that produces MSY.}

\item{figure}{Local, plots figure of production function as a function of depletion (B/K)}
}
\value{
The production function exponent n (numeric).
}
\description{
For surplus production models, this function returns the production exponent n corresponding
to BMSY/K (Fletcher 1978).
}
\note{
May be useful for parameterizing \code{n} in \link{SP} and \link{SP_SS}.
}
\examples{
SP_production(0.5)
SP_production(0.5)
}
\references{
Fletcher, R. I. 1978. On the restructuring of the Pella-Tomlinson system. Fishery Bulletin 76:515:521.
}
\seealso{
\link{SP} \link{SP_SS}
}
\author{
Q. Huynh
}
