% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.StoppingCriteria.R
\name{SlopeStoppingCriteria}
\alias{SlopeStoppingCriteria}
\title{Slope stopping criteria}
\description{
Class which send a stop signal when a time series stay constant.
}
\details{
Test the slope.
}
\examples{
stop_slope = SlopeStoppingCriteria$new( 20 , 500 , 1e-3 )
x = 0
while(!stop_slope$stop)
{
	stop_slope$append(base::exp(-x))
	x = x + 0.1
}
print(stop_slope$nit)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{minit}}{[integer] Minimal number of iterations. At least 3.}

\item{\code{maxit}}{[integer] Maximal number of iterations.}

\item{\code{nit}}{[integer] Number of iterations.}

\item{\code{tol}}{[float] Tolerance to control if slope is close to zero}

\item{\code{stop}}{[bool] If we stop}

\item{\code{criteria}}{[vector] State of criteria}

\item{\code{slope}}{[vector] Values of slope}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SlopeStoppingCriteria-new}{\code{SlopeStoppingCriteria$new()}}
\item \href{#method-SlopeStoppingCriteria-reset}{\code{SlopeStoppingCriteria$reset()}}
\item \href{#method-SlopeStoppingCriteria-append}{\code{SlopeStoppingCriteria$append()}}
\item \href{#method-SlopeStoppingCriteria-clone}{\code{SlopeStoppingCriteria$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SlopeStoppingCriteria-new"></a>}}
\if{latex}{\out{\hypertarget{method-SlopeStoppingCriteria-new}{}}}
\subsection{Method \code{new()}}{
Create a new SlopeStoppingCriteria object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlopeStoppingCriteria$new(minit, maxit, tol)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minit}}{[integer] Minimal number of iterations. At least 3.}

\item{\code{maxit}}{[integer] Maximal number of iterations.}

\item{\code{tol}}{[float] Tolerance to control if slope is close to zero}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `SlopeStoppingCriteria` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SlopeStoppingCriteria-reset"></a>}}
\if{latex}{\out{\hypertarget{method-SlopeStoppingCriteria-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlopeStoppingCriteria$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SlopeStoppingCriteria-append"></a>}}
\if{latex}{\out{\hypertarget{method-SlopeStoppingCriteria-append}{}}}
\subsection{Method \code{append()}}{
Add a new value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlopeStoppingCriteria$append(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{[double] New metrics}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SlopeStoppingCriteria-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SlopeStoppingCriteria-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlopeStoppingCriteria$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
