% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluate_dim_red}
\alias{evaluate_dim_red}
\title{Evaluate the dimensionality reduction}
\usage{
evaluate_dim_red(space, progression, k=5)
}
\arguments{
\item{space}{A numeric vector containing the inferred time points of each sample along a trajectory.}

\item{progression}{A factor or a numeric vector which represents the progression stages of each sample.}

\item{k}{The maximum number of nearest neighbours to search (default 5).}
}
\value{
The accuracy of a 5NN LOOCV using the dimensionality reduction to predict the progression stage of a sample.
}
\description{
\code{evaluate_dim_red} calculates the \emph{accuracy} of the
dimensionality reduction by performing 5-nearest neighbour leave-one-out-cross-validation (5NN LOOCV).
}
\examples{
## Generate a dataset
dataset <- generate_dataset(type="s", num_genes=500, num_samples=300, num_groups=4)
space <- reduce_dimensionality(dataset$expression, correlation_distance, ndim=2)

## Evaluate the trajectory timeline
evaluate_dim_red(space, dataset$sample_info$group_name)
}
