#' Snakes
#'
#' Measurements of snakes, some of which eat crayfish, and some of which do not.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 28 rows (each plot) and 4 columns:
#' \describe{
#'   \item{Crayfish}{Whether the snake lives in a crayfish region or not; one of \code{Cfish} or \code{NoCfish}}
#'   \item{Sex}{The snake sex; one of \code{male} or \code{female}}
#'   \item{SVL}{The snout-to-length length, in cm}
#'   \item{Teeth}{The number of number of maxillary teeth}
#' }
#' 
#' @source 
#' Javier Manjarrez, Constantino Macías Garcia, Hugh Drummond (2018). 
#' Data from: Morphological convergence in a Mexican garter snake associated
#' with the ingestion of a novel prey [Dataset]. 
#' Dryad. https://doi.org/10.5061/dryad.mg152
#' 
#' @references
#' Manjarrez, J., Macias Garcia, C., & Drummond, H. (2017). 
#' Morphological convergence in a Mexican garter snake associated 
#' with the ingestion of a novel prey. 
#' \emph{Ecology and Evolution}, \bold{7}(18), 7178--7186.
#' 
#' 
#' @usage 
#' data(Snakes)
#' 
#' @examples
#' plot( SVL ~ factor(Crayfish), data = Snakes, ylab = "SVL (cm)")
#' 

"Snakes"
