% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_nteachers_prov.R
\name{Get_nteachers_prov}
\alias{Get_nteachers_prov}
\title{Download the number of teachers in Italian schools by province}
\source{
<https://dati.istruzione.it/opendata/opendata/catalogo/elements1/?area=Personale+Scuola>
}
\usage{
Get_nteachers_prov(
  Year = 2023,
  verbose = TRUE,
  show_col_types = FALSE,
  filename = c("DOCTIT", "DOCSUP"),
  t_out = 3,
  autoAbort = FALSE,
  forceAbort = FALSE
)
}
\arguments{
\item{Year}{Numeric or character value. Reference school year for the school registry data (last available is 2023).
Available in the formats: \code{2022}, \code{"2021/2022"}, \code{202122}, \code{20212022.} \code{2023} by default}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{show_col_types}{Logical. If \code{TRUE}, if the 'verbose' argument is also \code{TRUE}, the columns of the raw dataset are shown during the download. \code{FALSE} by default.}

\item{filename}{Character. Which data to retrieve among the province counts of teachers/school personnel.
By default it is \code{c("DOCTIT", "DOCSUP")}, which are the file names used so far for the number of tenured and temporary teachers respectively.
Other file names are the following:}

\item{t_out}{Numeric. !! EXPERIMENTAL !! session timeout for scraping and download, in seconds. 3 seconds by default.}

\item{autoAbort}{Logical. Whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}

\item{forceAbort}{Logic. Whether to force a limited number of attempts to scrape the provider webpage.
Not recommended to be switched to \code{TRUE}. Only insert to speedup function failure when
there is certainty that the provider website is out. \code{FALSE} by default.
Experimental, may be implemented in other \code{Get_} functions.

\code{"ATATIT"} for the number of tenured non-teaching personnel


\code{"ATASUP"} for the number of temporary non-teaching personnel}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
This functions downloads the number of teachers by province from the open website of the Italian Ministry of Education, University and Research.
}
\details{
Please notice that by default, the function returns the count of the number of tenured and temporary teachers.
If either the count of non-teaching personnel or the count of a single category of teaching personnel is needed, please adapt
the \code{filename} argument accordingly.
}
\examples{


nteachers23 <- Get_nteachers_prov(Year=2023, filename="DOCTIT",
               autoAbort=TRUE, forceAbort = TRUE)
nteachers23[, c(3,4,5)]


}
