% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/final.score.R
\name{final.score}
\alias{final.score}
\title{Final Score}
\usage{
final.score(test.table, cutoff, somatic, output.name)
}
\arguments{
\item{test.table}{Data frame of kataegis test scores}

\item{cutoff}{The minimum hypermutation score used to classify the windows in the sliding binomial test as significant windows. The score is calculated per window as follows: -log10(binomial test p-value). Recommended value: 5}

\item{somatic}{Data frame of somatic variants}

\item{output.name}{Name of the generated output directory.}
}
\description{
Assigns hypermutation score (hm.score) and kataegic score (k.score)
}
\examples{
load(
	paste0(
		path.package("SeqKat"),
		"/extdata/test/somatic.rda"
		)
	);

load(
	paste0(
		path.package("SeqKat"),
		"/extdata/test/test.table.rda"
		)
	);

final.score(
	test.table,
	5,
	somatic,
	tempdir()
	);
}
\author{
Fan Fan

Fouad Yousif
}
