% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimreduc.R
\name{dim.DimReduc}
\alias{dim.DimReduc}
\alias{dimnames.DimReduc}
\alias{length.DimReduc}
\alias{names.DimReduc}
\title{Dimensional Reduction Meta-Information}
\usage{
\method{dim}{DimReduc}(x)

\method{dimnames}{DimReduc}(x)

\method{length}{DimReduc}(x)

\method{names}{DimReduc}(x)
}
\arguments{
\item{x}{A \code{\link{DimReduc}} object}
}
\value{
\code{dim}: The number of cells (\code{nrow}) and dimensions
(\code{ncol})

\code{dimnames}: The cell (row) and dimension (column) names

\code{length}: The number of dimensions

\code{names}: The dimension identifiers
}
\description{
Pull meta-information about cells and dimensions for a given
\link[=DimReduc]{dimensional reduction}; cell meta-information is stored
as row meta-information (eg. \code{nrow}, \code{rownames}) and dimension
meta-information is stored as column meta-information (eg. \code{ncol},
\code{colnames})
}
\examples{
pca <- pbmc_small[["pca"]]
pca
dim(pca)

# nrow is number of cells
nrow(pca)

# rownames pulls cell names
head(rownames(pca))

# ncol and length are number of dimensions
ncol(pca)
length(pca)

# colnames and names pull dimension identifiers
head(colnames(pca))
head(names(pca))

}
\seealso{
\code{Cells}

Dimensional reduction object, validity, and interaction methods
\code{\link{CreateDimReducObject}()},
\code{\link{DimReduc-class}},
\code{\link{DimReduc-validity}},
\code{\link{[.DimReduc}()},
\code{\link{[[.DimReduc}()},
\code{\link{merge.DimReduc}()},
\code{\link{print.DimReduc}()},
\code{\link{subset.DimReduc}()}
}
\concept{dimreduc}
