% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design.R
\name{expandDesign}
\alias{expandDesign}
\title{Create the simulation design object}
\usage{
expandDesign(Design, repeat_conditions)
}
\arguments{
\item{Design}{object created by \code{\link{createDesign}} which should have
its rows repeated for optimal HPC schedulers}

\item{repeat_conditions}{integer vector used to repeat each design row
  the specified number of times. Can either be a single integer, which repeats
  each row this many times, or an integer vector equal to the number of total
  rows in the created object.

  This argument is useful when distributing independent row conditions to
  cluster computing environments, particularly with different \code{replication}
  information. For example, if 1000 replications in total are the target but
  the condition is repeated over 4 rows then only 250 replications per row
  would be required across the repeated conditions. See
  \code{\link{aggregate_simulations}} for combining the simulation objects
  once complete}
}
\value{
a \code{tibble} or \code{data.frame} containing the simulation experiment
  conditions to be evaluated in \code{\link{runSimulation}}
}
\description{
Repeat each design row the specified number of times. This is primarily used
for cluster computing where jobs are distributed with batches of replications
and later aggregated into a complete simulation object
(see \code{\link{runArraySimulation}} and \code{\link{aggregate_simulations}}).
}
\examples{
\dontrun{

# repeat each row 4 times (for cluster computing)
Design <- createDesign(N = c(10, 20),
                       SD.equal = c(TRUE, FALSE))
Design4 <- expandDesign(Design, 4)
Design4

# repeat first two rows 2x and the rest 4 times (for cluster computing
#   where first two conditions are faster to execute)
Design <- createDesign(SD.equal = c(TRUE, FALSE),
                       N = c(10, 100, 1000))
Design24 <- expandDesign(Design, c(2,2,rep(4, 4)))
Design24

}
}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{createDesign}}, \code{\link{aggregate_simulations}},
   \code{\link{runArraySimulation}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
