% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_outer.R
\docType{methods}
\name{run_outer}
\alias{run_outer}
\alias{run_outer,numeric,numeric,SimInf_model-method}
\title{Run \code{SimInf_model} on scaled parameters}
\usage{
run_outer(x, y, model, formula = NULL, FUN = NULL, ...)

\S4method{run_outer}{numeric,numeric,SimInf_model}(x, y, model,
  formula = NULL, FUN = NULL, ...)
}
\arguments{
\item{x}{Scale the model \code{gdata} parameter values on the
right hand side of the formula with \code{x} before calling
\code{FUN} with the scaled model as argument.}

\item{y}{Scale the model \code{gdata} parameter values on the
left hand side of the formula with \code{y} before calling
\code{FUN} with the scaled model as argument.}

\item{model}{The siminf model to scale parameters on and run.}

\item{formula}{The parameters in the \code{gdata} vector matching
the left hand side of the formula \code{a + b ~ c} will be
scaled by \code{y}.  The parameters in the \code{gdata} vector
matching the right hand side of the formula \code{a + b ~ c}
will be scaled by \code{x}.}

\item{FUN}{A function to use on the scaled model 'gdata' parameters.}

\item{...}{Optional arguments to be passed to \code{FUN}.}
}
\value{
Array with dimension \code{c(dim(x), dim(y))}.
}
\description{
Run \code{SimInf_model} on scaled parameters
}
\examples{
\dontrun{
## Define a function that runs the model and
## returns the prevalence at the last day.
run_f <- function(model) {prevalence(run(model))[length(model@tspan)]}

## Define scaling parameters
x = seq(from = 0.95, to = 1.05, by = 0.01)
y = seq(from = 0.95, to = 1.05, by = 0.01)

## Run model
model <- demo_model(nodes = 10)
formula <- upsilon ~ beta_t1 + beta_t2 + beta_t3 + beta_t4
z <- run_outer(x, y, model, formula, run_f)

## Plot
filled.contour(x, y, z)
}
}
