% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_model.R
\name{outdegree}
\alias{outdegree}
\title{Determine out-degree for each node in a model}
\usage{
outdegree(model)
}
\arguments{
\item{model}{determine out-degree for each node in the model.}
}
\value{
vector with out-degree for each node.
}
\description{
The number nodes that are connected with \emph{external transfer}
events from each node.
}
\examples{
## Create an 'SIR' model with 1600 nodes and initialize
## it with example data.
model <- SIR(u0 = u0_SIR(), tspan = 1:1460, events = events_SIR(),
             beta   = 0.16, gamma  = 0.077)

## Display outdegree for each node in the model.
plot(outdegree(model))
}
