## ----eval=FALSE---------------------------------------------------------------
#  install.packages("SkeletalVis")

## -----------------------------------------------------------------------------
library(SkeletalVis)

## ----eval=FALSE---------------------------------------------------------------
#  skeletalvis <- load_skeletalvis()

## -----------------------------------------------------------------------------
# Set demo=TRUE to load a small example database
skeletalvis <- load_skeletalvis(demo=TRUE)


## -----------------------------------------------------------------------------
# Retrieve the data for SOX9 in the expression profiles
gene_results <- get_gene_fold_changes(skeletalvis, "SOX9", return_fdr = TRUE)
head(gene_results)

## -----------------------------------------------------------------------------
experiments <- search_skeletalvis(skeletalvis, "SOX9")
experiments

## -----------------------------------------------------------------------------
experiments <- search_skeletalvis(skeletalvis, "synovium", columns = "Tissue")
head(experiments)

## -----------------------------------------------------------------------------
get_comparisons(skeletalvis, accession = "GSE155118" )

## ----eval=FALSE---------------------------------------------------------------
#  browse_skeletalvis(skeletalvis)

## -----------------------------------------------------------------------------
experiment_results <- get_experiment(skeletalvis, "GSE155118_1")
head(experiment_results)

## -----------------------------------------------------------------------------
genes_of_interest <- c("SOX5","SOX6","SOX9","ACAN")

experiment_results[ experiment_results$ID %in% genes_of_interest, ]

## -----------------------------------------------------------------------------
# Data with an absolute fold change of 2 and FDR < 0.05
experiment_results_sig <- experiment_results[ abs(experiment_results$GSE155118_1_log2FoldChange) > log2(2) & experiment_results$GSE155118_1_FDR < 0.05, ]

# How many genes passing this threshold?
dim(experiment_results_sig)

# Look at the top of the list
head(experiment_results_sig)

## -----------------------------------------------------------------------------
volcano_plot(experiment_results, number_points=5, interactive = FALSE)

## -----------------------------------------------------------------------------
#  volcano_plot(experiment_results, interactive = TRUE)

## -----------------------------------------------------------------------------
# Selected genes and top 10 up and down by FDR
volcano_plot(experiment_results, number_points = 5, selected_points = c("SOX5","SOX6","SOX9"))

# Just label the selected genes
volcano_plot(experiment_results, number_points = 0, selected_points = c("SOX5","SOX6","SOX9"))

## -----------------------------------------------------------------------------
g <- volcano_plot(gene_results)

g

## -----------------------------------------------------------------------------
# Load an example built in dataset
data(query)

dim(query)
head(query)



## -----------------------------------------------------------------------------
# Get the similarity of this experiment against the skeletalvis databases
similarity_table <- experiment_similarity(skeletalvis, query)
  

## -----------------------------------------------------------------------------
# Look at the top few rows
head(similarity_table)

## -----------------------------------------------------------------------------
# Look at the bottom few rows
tail(similarity_table)

## -----------------------------------------------------------------------------
# Plot the similarity results and label the top 5 experiments
plot_similarity(similarity_table, top_n=5)

## -----------------------------------------------------------------------------
oagenes_curated <- view_curated_oagenes(skeletalvis)

head(oagenes_curated)

## -----------------------------------------------------------------------------
oagenes_prioritised <- view_prioritised_oagenes(skeletalvis)

head(oagenes_prioritised)

## -----------------------------------------------------------------------------
#  view_network(skeletalvis, query = "COL2A1")

