% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Probability_parameter.R
\name{train_parameter_model}
\alias{train_parameter_model}
\title{Train Parameter Prediction Model (Use in package)}
\usage{
train_parameter_model(
  training_data,
  method = "ensemble",
  n_models = 3,
  verbose = TRUE
)
}
\arguments{
\item{training_data}{Data frame with features and target parameters}

\item{method}{Machine learning method to use}

\item{n_models}{Number of models for ensemble learning}

\item{verbose}{Whether to print training progress}
}
\value{
List containing trained model and performance metrics
}
\description{
Trains machine learning models to predict optimal parameters
based on dataset characteristics.
}
\seealso{
Other Section_1_Functions_Use_in_Package: 
\code{\link{calculate_cluster_variability}()},
\code{\link{calculate_expression}()},
\code{\link{calculate_expression_skewness}()},
\code{\link{calculate_probability}()},
\code{\link{estimate_batch_effect}()},
\code{\link{extract_dataset_features}()},
\code{\link{generate_training_data}()},
\code{\link{postprocess_parameters}()},
\code{\link{predict_optimal_parameters}()}
}
\concept{Section_1_Functions_Use_in_Package}
