% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparkR.R
\name{sparkR.init}
\alias{sparkR.init}
\title{(Deprecated) Initialize a new Spark Context}
\usage{
sparkR.init(master = "", appName = "SparkR",
  sparkHome = Sys.getenv("SPARK_HOME"), sparkEnvir = list(),
  sparkExecutorEnv = list(), sparkJars = "", sparkPackages = "")
}
\arguments{
\item{master}{The Spark master URL}

\item{appName}{Application name to register with cluster manager}

\item{sparkHome}{Spark Home directory}

\item{sparkEnvir}{Named list of environment variables to set on worker nodes}

\item{sparkExecutorEnv}{Named list of environment variables to be used when launching executors}

\item{sparkJars}{Character vector of jar files to pass to the worker nodes}

\item{sparkPackages}{Character vector of package coordinates}
}
\description{
This function initializes a new SparkContext.
}
\note{
sparkR.init since 1.4.0
}
\examples{
\dontrun{
sc <- sparkR.init("local[2]", "SparkR", "/home/spark")
sc <- sparkR.init("local[2]", "SparkR", "/home/spark",
                 list(spark.executor.memory="1g"))
sc <- sparkR.init("yarn-client", "SparkR", "/home/spark",
                 list(spark.executor.memory="4g"),
                 list(LD_LIBRARY_PATH="/directory of JVM libraries (libjvm.so) on workers/"),
                 c("one.jar", "two.jar", "three.jar"),
                 c("com.databricks:spark-avro_2.10:2.0.1"))
}
}
\seealso{
\link{sparkR.session}
}
