% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{calculateEvalMetrics}
\alias{calculateEvalMetrics}
\title{Calculate evaluation metrics on test mixed transcriptional profiles}
\usage{
calculateEvalMetrics(object)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with a trained model in
\code{trained.model} slot and the actual cell proportions of test mixed
profiles in \code{prob.cell.types} slot.}
}
\value{
A \code{\linkS4class{SpatialDDLS}} object with is a
\code{\linkS4class{DeconvDLModel}} object. The calculated metrics are
stored in the \code{test.deconv.metrics} slot of the
\code{\linkS4class{DeconvDLModel}} object.
}
\description{
Calculate evaluation metrics on test mixed transcriptional profiles. By
default, absolute error (\code{AbsErr}), proportional absolute error
(\code{ppAbsErr}), squared error (\code{SqrErr}), and proportional squared
error (\code{ppSqrErr}) are calculated for each test mixed profile. In
addition, each of these metrics is aggregated according to three criteria:
cell type (\code{CellType}), probability bins in ranges of 0.1 (\code{pBin}),
and number of different cell types present in the spot (\code{nCellTypes}).
}
\seealso{
\code{\link{distErrorPlot}} \code{\link{corrExpPredPlot}}
\code{\link{blandAltmanLehPlot}} \code{\link{barErrorPlot}}
}
