% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_wasserstein_boostrap.R
\name{wassboot}
\alias{wassboot}
\title{Wasserstein Distance Estimation with Boostrapping}
\usage{
wassboot(X, Y, p = 2, B = 500, wx = NULL, wy = NULL)
}
\arguments{
\item{X}{an \eqn{(M\times P)} matrix of row observations.}

\item{Y}{an \eqn{(N\times P)} matrix of row observations.}

\item{p}{an exponent for the order of the distance (default: 2).}

\item{B}{number of bootstrap samples (default: 500).}

\item{wx}{a length-\eqn{M} marginal density that sums to \eqn{1}. If \code{NULL} (default), uniform weight is set.}

\item{wy}{a length-\eqn{N} marginal density that sums to \eqn{1}. If \code{NULL} (default), uniform weight is set.}
}
\value{
a named list containing\describe{
\item{distance}{\eqn{\mathcal{W}_p} distance value.}
\item{boot_samples}{a length-\eqn{B} vector of bootstrap samples.}
}
}
\description{
This function computes the \eqn{\mathcal{W}_p} distance between two empirical measures 
using bootstrap in order to quantify the uncertainty of the estimation.
}
\examples{
\donttest{
#-------------------------------------------------------------------
#  Boostrapping Wasserstein Distance between Two Bivariate Normals
#
# * class 1 : samples from Gaussian with mean=(-5, 0)
# * class 2 : samples from Gaussian with mean=(+5, 0)
#-------------------------------------------------------------------
## SMALL EXAMPLE
m = round(runif(1, min=50, max=100))
n = round(runif(1, min=50, max=100))
X = matrix(rnorm(m*2), ncol=2) # m obs. for X
Y = matrix(rnorm(n*2), ncol=2) # n obs. for Y

X[,1] = X[,1] - 5
Y[,1] = Y[,1] + 5

## COMPUTE THE BOOTSTRAP SAMPLES
boots = wassboot(X, Y, B=1000)

## VISUALIZE
opar <- par(no.readonly=TRUE)
hist(boots$boot_samples, xlab="Estimates", main="Bootstrap Samples")
abline(v=boots$distance, lwd=2, col="blue")
abline(v=mean(boots$boot_samples), lwd=2, col="red")
abline(v=10, col="cyan", lwd=2)
legend("topright", c("ground truth","estimate","bootstrap mean"), 
        col=c("cyan","blue","red"), lwd=2)
par(opar)
}

}
\concept{dist}
