% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_9e.R
\name{get_genetic_profiles}
\alias{get_genetic_profiles}
\title{Retrieve Genetic Profiles for a TCGA Study of Interest}
\usage{
get_genetic_profiles(csid = NULL, dryrun = FALSE)
}
\arguments{
\item{csid}{String corresponding to the cancer study id of interest}

\item{dryrun}{Logical. If TRUE, all other arguments (if any) are ignored and 
a representative example is returned as output. No Internet connection is 
required for executing the operation when `dryrun` is TRUE.}
}
\value{
data.frame including information about genetic profiles.
}
\description{
Retrieve Information about all genetic profiles associated with a cancer study of interest.
Each cancer study includes one or more types of molecular analyses.  The corresponding assays or 
platforms are referred to as genetic profiles. 
A genetic profile identifier is required to download molecular data.
}
\examples{
# Set `dryrun = FALSE` (default option) in production!
get_genetic_profiles("blca_tcga", dryrun = TRUE)  


}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
