% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omics-data.R
\docType{data}
\name{omics}
\alias{omics}
\title{Lung-cancer cell lines data in cancer cell line encyclopedia (CCLE) dataset}
\format{
A list contains two objects:
\describe{
  \item{omics}{a 3-dimensional array with size (3, 10, 68)}
  \item{Y}{a 68-length vector representing the response variable}
}
}
\source{
\href{https://string-db.org}{https://string-db.org}
}
\usage{
data(omics)
}
\description{
The omics data is a subset of the dataset provided by cancer cell line
encyclopedia (CCLE) project (Barretina et al., 2012;
\url{https://sites.broadinstitute.org/ccle/}).
}
\details{
This data consists of one response variable and ten genes
evaluated under three different platforms. 

The response variable measures the log-transformed activity area of taking 
Vandertanib, a drug targeting on EGFR gene for lung cancer. 

The three platforms are DNA copy number variation (CNV), methylation and mRNA 
expression.

Among the 10 genes, 7 of them (EGFR, EREG, HRAS, KRAS, PTPN11, STAT3, and
TGFA) are involved in the protein-protein interaction network of EGFR 
(\href{https://string-db.org}{https://string-db.org}) and the rest (ACTB, 
GAPDH, and PPIA) are arbitrarily chosen housekeeping genes and play the role
of negative control. 

Detailed pre-processing procedure is available in Chang et al. (2021).
}
\examples{
data(omics)
names(omics)
dim(omics$omics)
# 3 10 68
}
\references{
Barretina, J., Caponigro, G., Stransky, N. et al. 
The Cancer Cell Line Encyclopedia enables predictive modelling of anticancer 
drug sensitivity. Nature 483, 603–607 (2012).
(\href{https://www.nature.com/articles/nature11003}{Link})

Sheng-Mao Chang, Meng Yang, Wenbin Lu, Yu-Jyun Huang, Yueyang Huang, Hung Hung, 
Jeffrey C Miecznikowski, Tzu-Pin Lu, Jung-Ying Tzeng, 
Gene-set integrative analysis of multi-omics data using tensor-based association test, 
Bioinformatics, 2021;, btab125,
(\href{https://academic.oup.com/bioinformatics/advance-article-abstract/doi/10.1093/bioinformatics/btab125/6154849}{Link}))
}
\keyword{datasets}
