% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergeDensityFoldchange.R
\name{merge_density_foldchange}
\alias{merge_density_foldchange}
\title{Create high-density region plot with optional points, density rugs, and contours}
\usage{
merge_density_foldchange(
  data,
  x_var,
  y_var,
  group_var,
  palette = c("#3949ab", "#1e88e5", "#039be5", "#00897b", "#43a047", "#7cb342"),
  show_points = FALSE,
  point_size = 2.5,
  point_alpha = 0.2,
  x_lim = c(0, 20),
  y_lim = c(0, 20),
  cor_method = "pearson",
  line_size = 1.6,
  cor_label_pos = c("left", 0.97)
)
}
\arguments{
\item{data}{Data frame containing variables for plotting.}

\item{x_var}{Name of the x-axis variable as a string.}

\item{y_var}{Name of the y-axis variable as a string.}

\item{group_var}{Name of the grouping variable for color mapping as a string.}

\item{palette}{Color palette for the plot as a character vector.}

\item{show_points}{Logical, if TRUE adds points to the plot.}

\item{point_size}{Size of the points, relevant if show_points is TRUE.}

\item{point_alpha}{Transparency level of the points, relevant if show_points is TRUE.}

\item{x_lim}{Numeric vector of length 2, giving the x-axis limits.}

\item{y_lim}{Numeric vector of length 2, giving the y-axis limits.}

\item{cor_method}{Method to calculate correlation ("pearson" or "spearman").}

\item{line_size}{Size of the smoothing line.}

\item{cor_label_pos}{Vector of length 2 indicating the position of the correlation label (x and y).}
}
\value{
A ggplot object representing the high-density region plot.
}
\description{
This function creates a high-density region plot using hdr methods to
add density rug and filled contours. It also adds a regression line
and Pearson correlation label. Points can be added to the plot optionally.
}
\examples{
combined_df_file <- system.file("extdata", "combined_df.rds", package = "TransProR")
combined_df <- readRDS(combined_df_file)
pal1 = c("#3949ab","#1e88e5","#039be5","#00897b","#43a047","#7cb342")

all_density_foldchange_name1 <- merge_density_foldchange(
  data = combined_df,
  x_var = "log2FoldChange_1",
  y_var = "log2FoldChange_2",
  group_var = "name",
  palette = pal1,
  show_points = FALSE,
  point_size = 2.5,
  point_alpha = 0.1,
  x_lim = c(0, 20),
  y_lim = c(0, 20),
  cor_method = "pearson",
  line_size = 1.6,
  cor_label_pos = c("left", "top")
)

}
