% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cisl.R
\name{cisl}
\alias{cisl}
\title{Class Imbalanced Subsampling Lasso}
\usage{
cisl(
  x,
  y,
  r = 4,
  nB = 100,
  dfmax = 50,
  nlambda = 250,
  nMin = 0,
  replace = TRUE,
  betaPos = TRUE,
  ncore = 1
)
}
\arguments{
\item{x}{Input matrix, of dimension nobs x nvars. Each row is an
observation vector. Can be in sparse matrix format (inherit from class
\code{"sparseMatrix"} as in package \code{Matrix}).}

\item{y}{Binary response variable, numeric.}

\item{r}{Number of control in the CISL sampling. Default is 4.
See details below for other implementations.}

\item{nB}{Number of sub-samples. Default is 100.}

\item{dfmax}{Corresponds to the maximum size of the models visited with the
lasso (E in the paper). Default is 50.}

\item{nlambda}{Number of lambda values as is \code{glmnet} documentation.
Default is 250.}

\item{nMin}{Minimum number of events for a covariate to be considered.
Default is 0, all the covariates from \code{x} are considered.}

\item{replace}{Should sampling be with replacement? Default is TRUE.}

\item{betaPos}{If \code{betaPos=TRUE}, variable selection is based on positive
regression coefficient.
Else, variable selection is based on non-zero regression coefficient.
Default is TRUE.}

\item{ncore}{The number of calcul units used for parallel computing.
This has to be set to 1 if the \code{parallel} package is not available.
Default is 1.
WARNING: parallel computing is not supported for windows machines!}
}
\value{
An object with S3 class \code{"cisl"}.
\item{prob}{Matrix of dimension nvars x \code{nB}.
Quantity compute by CISL for each covariate, for each subsample.}
\item{q05}{5 \eqn{\%} quantile of the CISL quantity for each covariates.
Numeric, length equal to nvars.}
\item{q10}{10 \eqn{\%} quantile of the CISL quantity for each covariates.
Numeric, length equal to nvars.}
\item{q15}{15 \eqn{\%} quantile of the CISL quantity for each covariates.
Numeric, length equal to nvars.}
\item{q20}{20 \eqn{\%} quantile of the CISL quantity for each covariates.
Numeric, length equal to nvars.}
}
\description{
Implementation of CISL and the stability selection according to subsampling options.
}
\details{
CISL is a variation of the stability method adapted to characteristics of pharmacovigilance databases.
Tunning \code{r = 4} and \code{replace = TRUE} are used to implement our CISL sampling.
For instance, \code{r = NULL} and \code{replace = FALSE} can be used to
implement the \eqn{n \over 2} sampling in Stability Selection.
}
\examples{

set.seed(15)
drugs <- matrix(rbinom(100*20, 1, 0.2), nrow = 100, ncol = 20)
colnames(drugs) <- paste0("drugs",1:ncol(drugs))
ae <- rbinom(100, 1, 0.3)
lcisl <- cisl(x = drugs, y = ae, nB = 50)

}
\references{
Ahmed, I., Pariente, A., & Tubert-Bitter, P. (2018). "Class-imbalanced subsampling lasso algorithm for discovering adverse drug reactions".
\emph{Statistical Methods in Medical Research}. 27(3), 785–797, \url{https://doi.org/10.1177/0962280216643116}
}
\author{
Ismail Ahmed
}
