% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_plan.R
\name{as_tibble.alias.matrix}
\alias{as_tibble.alias.matrix}
\title{Convert an alias matrix to a tibble}
\usage{
\method{as_tibble}{alias.matrix}(x, ..., compact = TRUE)
}
\arguments{
\item{x}{the alias matrix object.}

\item{...}{additional arguments to \code{as_tibble}.}

\item{compact}{a logical: if TRUE, it reports all possible effects
combinations, even those with no alias.}
}
\value{
a tibble representation of the alias matrix
}
\description{
Given an alias matrix, this function returns a tidy tibble of the
alias structures, with the added \code{generator} column containing the generator
(i.e. right-hand side) of the defining relationship that generates each
alias.
}
\examples{
tibble::as_tibble(fp_alias_matrix(~A*B*C, ~B*C*D))
}
