% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01genericSupport.r
\name{amigaDateToRaw}
\alias{amigaDateToRaw}
\title{Convert date time objects into raw values}
\usage{
amigaDateToRaw(x, format = c("long", "short"), tz = "UTC")
}
\arguments{
\item{x}{A (\code{vector} of) \code{\link[base]{POSIXt}} object(s).}

\item{format}{a \code{character} string indicating whether the date
should be stored as \code{short} or \code{long} integers.}

\item{tz}{A \code{character} string specifying the time zone to be used
to convert the date time object. Note that the time zone is not stored
on the Amiga. By default the Universal time zone (UTC) is assumed.
You will get a warning when you use a timezone other then UTC.}
}
\value{
returns \code{raw} data reflecting the date-time objects conform
the Amiga file system specifications.
}
\description{
This function converts date-time objects into raw data conform
Amiga file system specifications.
}
\details{
The Amiga file system stores date time objects as three unsigned
short (16 bit) or long (32 bit) integers. Where the values are
number of days, minutes and ticks (fiftieth of a second) since
1978-01-01 respectively.

As these values are always positive, only date time values on or after
1978-01-01 are allowed. The inverse of this function can be achieved
with \code{\link{rawToAmigaDate}}.
}
\examples{
## Note that using the same date-time with different timezones will
## result in different raw data. The time zone is not stored.
amigaDateToRaw(as.POSIXct("1978-01-01 13:30", tz = "UTC"))
amigaDateToRaw(as.POSIXct("1978-01-01 13:30", tz = "CET"))
}
\seealso{
Other raw.operations: \code{\link{amigaIntToRaw}},
  \code{\link{displayRawData}},
  \code{\link{rawToAmigaDate}}, \code{\link{rawToAmigaInt}}
}
\author{
Pepijn de Vries
}
