% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_exist.R
\name{filter_not_exist}
\alias{filter_not_exist}
\title{Returns records that don't fit into existing by groups in a filtered source dataset}
\usage{
filter_not_exist(dataset, dataset_add, by_vars, filter_add = NULL)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{dataset_add}{Source dataset

The source dataset, which determines the by groups returned in the input dataset,
based on the groups that don't exist in this dataset after being subset by \code{filter_add}.

The variables specified in the \code{by_vars} and \code{filter_add} parameters are expected
in this dataset.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

\describe{
\item{Default value}{none}
}}

\item{filter_add}{Filter for the source dataset

The filter condition which will be used to subset the source dataset.
Alternatively, if no filter condition is supplied, no subsetting of the source
dataset will be performed.

\describe{
\item{Default value}{\code{NULL}}
}}
}
\value{
The records in the input dataset which are not contained within any existing by
group in the filtered source dataset.
}
\description{
Returns all records in the input dataset that belong to by groups that are not
present in a source dataset, after the source dataset is optionally filtered. For
example, this could be used to return ADSL records for subjects that didn't take certain
concomitant medications during the course of the study (as per records in ADCM).
}
\details{
Returns the records in \code{dataset} which don't match any existing by groups in
\code{dataset_add}, after being filtered according to \code{filter_add}. If all by
groups that exist in \code{dataset} don't exist in \code{dataset_add}, an empty dataset will
be returned.
}
\examples{
# Get demographic information about subjects who didn't take vitamin supplements
# during the study

library(tibble)

adsl <- tribble(
  ~USUBJID,      ~AGE, ~SEX,
  "01-701-1015", 63,   "F",
  "01-701-1023", 64,   "M",
  "01-701-1034", 77,   "F",
  "01-701-1118", 52,   "M"
)

adcm <- tribble(
  ~USUBJID,      ~CMTRT,         ~CMSTDTC,
  "01-701-1015", "ASPIRIN",      "2013-05-14",
  "01-701-1023", "MYLANTA",      "2014-01-04",
  "01-701-1023", "CALCIUM",      "2014-02-25",
  "01-701-1034", "VITAMIN C",    "2013-12-12",
  "01-701-1034", "CALCIUM",      "2013-03-27",
  "01-701-1118", "MULTIVITAMIN", "2013-02-21"
)

filter_not_exist(
  dataset = adsl,
  dataset_add = adcm,
  by_vars = exprs(USUBJID),
  filter_add = str_detect(CMTRT, "VITAMIN")
)

}
\seealso{
Utilities for Filtering Observations: 
\code{\link{count_vals}()},
\code{\link{filter_exist}()},
\code{\link{filter_extreme}()},
\code{\link{filter_joined}()},
\code{\link{filter_relative}()},
\code{\link{max_cond}()},
\code{\link{min_cond}()}
}
\concept{utils_fil}
\keyword{utils_fil}
