% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_unit}
\alias{assert_unit}
\title{Asserts That a Parameter is Provided in the Expected Unit}
\usage{
assert_unit(
  dataset,
  param,
  required_unit = NULL,
  get_unit_expr,
  arg_name = rlang::caller_arg(required_unit),
  message = NULL,
  class = "assert_unit",
  call = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset to be checked

The variable \code{PARAMCD} and those used in \code{get_unit_expr} are expected.

\describe{
\item{Default value}{none}
}}

\item{param}{Parameter code of the parameter to check

\describe{
\item{Default value}{none}
}}

\item{required_unit}{Expected unit(s)

If the argument is set to \code{NULL}, it is checked only whether the unit is
unique within the parameter.

\describe{
\item{Permitted values}{A character vector or \code{NULL}}
\item{Default value}{\code{NULL}}
}}

\item{get_unit_expr}{Expression used to provide the unit of \code{param}

\describe{
\item{Default value}{none}
}}

\item{arg_name}{string indicating the label/symbol of the object being checked.

\describe{
\item{Default value}{\code{rlang::caller_arg(arg)}}
}}

\item{message}{string passed to \code{cli::cli_abort(message)}.
When \code{NULL}, default messaging is used (see examples for default messages).
\code{"{arg_name}"} can be used in messaging.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{class}{Subclass of the condition.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
The function throws an error
\itemize{
\item if there is more than one non-missing unit in the dataset or
\item if the unit variable differs from the expected unit for any observation of
the parameter in the input dataset.
}

Otherwise, the dataset is returned invisibly.
}
\description{
Checks if a parameter (\code{PARAMCD}) in a dataset is provided in the expected
unit.
}
\examples{
library(dplyr)

advs <- tribble(
  ~USUBJID, ~VSTESTCD, ~VSTRESN, ~VSSTRESU, ~PARAMCD, ~AVAL,
  "P01",    "WEIGHT",      80.1, "kg",      "WEIGHT",  80.1,
  "P02",    "WEIGHT",      85.7, "kg",      "WEIGHT",  85.7
)

assert_unit(advs, param = "WEIGHT", required_unit = "kg", get_unit_expr = VSSTRESU)

try(
  assert_unit(
    advs,
    param = "WEIGHT",
    required_unit = c("g", "mg"),
    get_unit_expr = VSSTRESU
  )
)

# Checking uniqueness of unit only
advs <- tribble(
  ~USUBJID, ~VSTESTCD, ~VSTRESN, ~VSSTRESU, ~PARAMCD, ~AVAL,
  "P01",    "WEIGHT",      80.1, "kg",      "WEIGHT",  80.1,
  "P02",    "WEIGHT",     85700, "g",       "WEIGHT", 85700
)

try(
  assert_unit(advs, param = "WEIGHT", get_unit_expr = VSSTRESU)
)
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
