% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_design.factorial_rcbd}
\alias{plot_design.factorial_rcbd}
\title{Plot Factorial Designs with rcbd Design}
\usage{
plot_design.factorial_rcbd(
  design,
  y = "row",
  factor_name = "A",
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_x = FALSE,
  reverse_y = FALSE
)
}
\arguments{
\item{design}{outdesign from \code{agricolae} package}

\item{y}{Describes the y coordinates of a experiment design}

\item{factor_name}{Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
Plot a design of a factorial  experiment with randomized complete block design (rcbd) from design.ab
}
\examples{
library(agricolaeplotr)
library(agricolae)
trt<-c(2,4)
k=6
outdesign<-design.ab(trt, r=k, serie=3,design='rcbd')
plot_design.factorial_rcbd(design=outdesign,factor_name = 'B')
plot_design.factorial_rcbd(outdesign,reverse_y = TRUE,reverse_x = TRUE)

}
