% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda_sampling_rate.R
\name{summarize_sampling_rate}
\alias{summarize_sampling_rate}
\alias{summarize_sampling_rate.track_xyt}
\alias{summarize_sampling_rate_many}
\alias{summarize_sampling_rate_many.track_xyt}
\title{Returns a summary of sampling rates}
\usage{
summarize_sampling_rate(x, ...)

\method{summarize_sampling_rate}{track_xyt}(
  x,
  time_unit = "auto",
  summarize = TRUE,
  as_tibble = TRUE,
  ...
)

summarize_sampling_rate_many(x, ...)

\method{summarize_sampling_rate_many}{track_xyt}(x, cols, time_unit = "auto", ...)
}
\arguments{
\item{x}{A \code{track_xyt}.}

\item{...}{Further arguments, none implemented.}

\item{time_unit}{\verb{[character(1) = "auto"]} \cr Which time unit will be used.}

\item{summarize}{A logical. If \code{TRUE} a summary is returned, otherwise raw
sampling intervals are returned.}

\item{as_tibble}{A logical. Should result be returned as \code{tibble} or as
\code{table}.}

\item{cols}{Columns used for grouping.}
}
\value{
Depending on \code{summarize} and \code{as_tibble}, a vector, table or tibble.
}
\description{
Returns a summary of sampling rates
}
\examples{
data(deer)
amt::summarize_sampling_rate(deer)

data(amt_fisher)
# Add the month
amt_fisher |> mutate(yday = lubridate::yday(t_)) |>
summarize_sampling_rate_many(c("id", "yday"))

}
