% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions-meta-pipelines.R
\docType{class}
\name{MetaAnalysisPipeline-class}
\alias{MetaAnalysisPipeline-class}
\alias{MetaAnalysisPipeline}
\title{Class for creating and working with meta-pipelines}
\description{
Class for creating and working with meta-pipelines
}
\details{
This class works with the \code{AnalysisPipeline} and \code{StreamingAnalysisPipeline} classes, and allows the
pipeline to be exported as meta-pipeline. A meta-pipeline is a construct, where the input dataset as well as the arguments
to functions in the pipeline are not defined. Only the analysis flow and dependencies are stored.
}
\section{Slots}{

\describe{
\item{\code{pipeline}}{A tibble which holds functions to be called in the pipeline}

\item{\code{pipelinePrototype}}{An object of class \code{proto} from the 'proto' package which maintains the prototype of the
functions in the pipeline and their respective arguments}

\item{\code{type}}{A string defining whether it is a batch or streaming pipeline. Acceptable values are 'batch' & 'streaming'}
}}

\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
