% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{ax_proxy_series}
\alias{ax_proxy_series}
\title{Proxy for updating series.}
\usage{
ax_proxy_series(proxy, newSeries, animate = TRUE)
}
\arguments{
\item{proxy}{A \code{apexchartProxy} \code{htmlwidget} object.}

\item{newSeries}{The series array to override the existing one.}

\item{animate}{Should the chart animate on re-rendering.}
}
\description{
Allows you to update the series array overriding the existing one.
}
\examples{

if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    fluidRow(
      column(
        width = 8, offset = 2,
        tags$h2("Real time chart"),
        apexchartOutput(outputId = "chart")
      )
    )
  )

  server <- function(input, output, session) {

    rv <- reactiveValues()
    rv$df <- data.frame(
      date = Sys.Date() + 1:20,
      values = sample(10:90, 20, TRUE)
    )

    observe({
      invalidateLater(1000, session)
      df <- isolate(rv$df)
      # Append new line of data
      df <- rbind(
        df, data.frame(
          date = df$date[length(df$date)] + 1,
          values = sample(10:90, 1, TRUE)
        )
      )
      rv$df <- df
    })

    output$chart <- renderApexchart({
      # Generate chart once
      apex(isolate(rv$df), aes(date, values), "spline") \%>\%
        ax_xaxis(
          range = 10 * 24 * 60 * 60 * 1000
          # Fixed range for x-axis : 10 days
          # days*hours*minutes*seconds*milliseconds
        )
    })

    observe({
      # Update chart to add new data
      apexchartProxy("chart") \%>\%
        ax_proxy_series(
          parse_df(rv$df),
          T
        )
    })

  }

  shinyApp(ui, server)
}

}
