% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arena.R
\name{print.arena_static}
\alias{print.arena_static}
\title{Prints static arena summary}
\usage{
\method{print}{arena_static}(x, ...)
}
\arguments{
\item{x}{\code{arena_static} object}

\item{...}{other parameters}
}
\value{
None
}
\description{
Prints static arena summary
}
\examples{
library("DALEX")
library("arenar")
library("dplyr", quietly=TRUE, warn.conflicts = FALSE)
# create a model
model <- glm(m2.price ~ ., data=apartments)
# create a DALEX explainer
explainer <- DALEX::explain(model, data=apartments, y=apartments$m2.price)
# prepare observations to be explained
observations <- apartments[1:3, ]
# rownames are used as labels for each observation
rownames(observations) <- paste0(observations$construction.year, "-", observations$surface, "m2")
# generate static arena for one model and 3 observations
arena <- create_arena(live=FALSE) \%>\% push_model(explainer) \%>\% push_observations(observations)
# print summary
print(arena)
}
