% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_dm_slide.R
\name{t_dm_slide}
\alias{t_dm_slide}
\title{Demographic table}
\usage{
t_dm_slide(
  adsl,
  arm = "TRT01P",
  vars = c("AGE", "SEX", "RACE"),
  stats = c("median", "range", "count_fraction"),
  split_by_study = FALSE,
  side_by_side = NULL
)
}
\arguments{
\item{adsl}{ADSL data set, dataframe}

\item{arm}{Arm variable, character, "`TRT01P" by default.}

\item{vars}{Characters of variables}

\item{stats}{see `.stats` from [tern::analyze_vars()]}

\item{split_by_study}{Split by study, building structured header for tables}

\item{side_by_side}{"GlobalAsia" or "GlobalAsiaChina" to define the side by side requirement}
}
\value{
rtables object
}
\description{
Demographic table
}
\note{
* Default arm variables are set to `"TRT01A"` for safety output, and
 `"TRT01P"` for efficacy output
}
\examples{
library(dplyr)
adsl <- eg_adsl
out1 <- t_dm_slide(adsl, "TRT01P", c("SEX", "AGE", "RACE", "ETHNIC", "COUNTRY"))
print(out1)
generate_slides(out1, paste0(tempdir(), "/dm.pptx"))

out2 <- t_dm_slide(adsl, "TRT01P", c("SEX", "AGE", "RACE", "ETHNIC", "COUNTRY"),
  split_by_study = TRUE
)
print(out2)

}
