% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ith.R
\name{ith}
\alias{ith}
\title{Calculation of ITH index}
\usage{
ith(raster.list = raster.list)
}
\arguments{
\item{raster.list}{Spat Raster variable with several variables and times or only one Spat Raster field}
}
\value{
Spat Raster with ITH calculation for each time
}
\description{
ITH index calculation is made from gridded observational or model data. If the data is needed in lat/lon projection is
better to use first the load.by.variable function to change projection

The index is calculated as:

\deqn{ITH = 1.8 * T(ºC) + 32 - (((0.55 - (0.55 * RelHum(\%))) / 100) * ((1.8 * T(ºC)) - 26))}

where T(ªC) is the temperature in celsius degrees and RelHum(\%) is the relative humidity in percentage
}
