% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bodyBuilder.R
\name{POSTbody_builder_directions_json}
\alias{POSTbody_builder_directions_json}
\title{Build JSON Parameter Body for Route Directions}
\usage{
POSTbody_builder_directions_json(params, tz)
}
\arguments{
\item{params}{A list of routing parameters, such as \code{travelMode},
\code{routeType}, \code{departAt}, etc.}

\item{tz}{A string specifying the timezone for any date-time parameters.}
}
\value{
A list of routing parameters, with values formatted and unboxed as
required for the JSON request.
}
\description{
Constructs the JSON part of the request body containing routing parameters
for the Azure Maps Route Directions API.
}
\examples{
\dontrun{
params <- list(
  travelMode = "car",
  routeType = "fastest"
)
json_part <- POSTbody_builder_directions_json(params, "UTC")
}
}
