% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{CatHDP}
\alias{CatHDP}
\title{Create objects of type "CatHDP".}
\usage{
CatHDP(
  objCopy = NULL,
  ENV = parent.frame(),
  gamma = list(gamma = 1, alpha = 1, j = 2)
)
}
\arguments{
\item{objCopy}{an object of type "CatHDP". If "objCopy" is not NULL, the function create a new "CatHDP" object by copying the content from objCopy, otherwise this new object will be created by using "ENV" and "gamma". Default NULL.}

\item{ENV}{environment, specify where the object will be created.}

\item{gamma}{list, a named list of parameters, gamma=list(gamma,alpha,j). Where gamma$gamma is a numeric value specifying the concentration parameter of DP(gamma,U), gamma$alpha is a numeric value specifying the concentration parameter of DP(alpha,G_j), gamma$j is the number of groups J.}
}
\value{
An object of class "CatHDP".
}
\description{
Create an object of type "CatHDP", which represents the Categorical-Hierarchical-Dirichlet-Process(Multinomial-Hierarchical-Dirichlet-Process) conjugate structure on positive integers:
     \deqn{G_j|gamma \sim DP(gamma,U), j = 1:J}
     \deqn{pi_j|G_j,alpha \sim DP(alpha,G_j)}
     \deqn{z|pi_j \sim Categorical(pi_j)}
     \deqn{k|z,G_j \sim Categorical(G_j), if z is a sample from the base measure G}
where DP(gamma,U) is a Dirichlet Process on positive integers, gamma is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_j) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_j. Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatHDP, z and k can only be positive integers. \cr
This object will be used as a place for recording and accumulating information in the related inference/sampling functions such as posterior(), posteriorDiscard(), rPosteriorPredictive() and so on.
}
\examples{
obj <- CatHDP(gamma=list(gamma=1,alpha=1,j=2))
obj #print the content
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{posterior.CatHDP}},\code{\link{posteriorDiscard.CatHDP}} ...
}
