% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complecs_to_precede.R
\name{complecs_to_precede}
\alias{complecs_to_precede}
\title{Represent a COMPLECS specification as a PRECEDE model}
\usage{
complecs_to_precede(
  input,
  title = "PRECEDE diagram",
  layout = "fdp",
  graph_styling = list(c("outputorder", "edgesfirst", "graph"), c("rankdir", "LR",
    "graph"), c("overlap", "false", "graph"), c("fixedsize", "false", "node"),
    c("fontname", "Arial", "graph"), c("fontname", "Arial", "node"), c("fillcolor",
    "White", "node"), c("shape", "box", "node"), c("style", "filled", "node"),
    c("fontname", "Arial", "edge"), c("headclip", "true", "edge"), c("tailclip", "false",
    "edge")),
  directed = TRUE,
  outputFile = NULL,
  outputWidth = 1600,
  outputHeight = NULL,
  returnDotOnly = FALSE,
  returnSvgOnly = FALSE,
  returnGraphOnly = TRUE,
  maxLabelLength = 60,
  regExReplacements = opts$get("diagrammerSanitization"),
  silent = opts$get("silent")
)
}
\arguments{
\item{input}{Either a link to a Google Sheet, or a path to an Excel file.}

\item{title}{The title of the COMPLECS graph.}

\item{layout}{The layout to use; has to be one of the \code{DiagrammeR} layout
types (\code{dot}, \code{neato}, \code{circo} and \code{twopi}).}

\item{graph_styling}{Additional styling to apply; a list with three-element
vectors, where the three elements correspond to, respectively, the \code{attr},
\code{value}, and \code{attr_type} arguments for \code{\link[DiagrammeR:add_global_graph_attrs]{DiagrammeR::add_global_graph_attrs()}}.
Note that these attributes may override attributes specified in the COMPLECS
specification.}

\item{directed}{Whether to draw directed arrows or not.}

\item{outputFile}{A character vector where each element is one path (including
filename) to write the graph to.}

\item{outputWidth, outputHeight}{If not \code{NULL}, a way to override the width and
height when calling \code{complecs} to generate a COMPLECS overview.}

\item{returnDotOnly}{Whether to only return the produced DOT code.}

\item{returnSvgOnly}{Whether to only return the SVG in a character vector.}

\item{returnGraphOnly}{Whether to only return the produced graph.}

\item{maxLabelLength}{The number of characters where to wrap the labels.}

\item{regExReplacements}{A list of pairs of regular
expressions that will be applied to the specifications
before generating the ABCD. This can be used to sanitize
problematic characters (e.g. ', " and \).}

\item{silent}{Whether to be chatty or silent.}
}
\value{
A \code{complecs} object that includes the graph and the graph in SVG in
\code{output$graph} and \code{output$graphSvg}.
}
\description{
This function reads in a complecs specification and draw a PRECEDE model,
with a number of assumptions (see Details section).
}
\details{
Only entities with the following entity types are used from the COMPLECS
specification:
\itemize{
\item \code{person}
\item \code{organization}
\item \code{environmental_condition}
\item \code{behavior}
\item \code{determinant}
\item \code{outcome}
}

Furthermore, it will be assumed that the only direct connections from
\code{behavior} entities to \code{outcome} entities belong to the focal population;
therefore, if behaviors of environmental actors are important for an
outcome, those behaviors' effects must be represented as
\code{environmental_condition} entities - otherwise the relevant \code{person}s or
\code{organizations}s will be erroneously considered as focal population members.
}
\examples{
\dontrun{
### Path in the package with example COMPLECS
exampleCOMPLECS <-
  system.file(
    "extdata",
    "COMPLECS-spec-example.xlsx",
    package = "behaviorchange"
  );

behaviorchange::complecs_to_precede(
  exampleCOMPLECS
);

### Loading that COMPLECS from a google sheet - but note that
### this requires an internet connection!
behaviorchange::complecs_to_precede(
  paste0(
    "https://docs.google.com/spreadsheets/d/",
    "1WMO15xroy4a0RfpuZ8GhT-NfDoxwS34w9PrWp8rGjjk"
  )
);
}
}
