% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerbf01.R
\name{plot.power.bftest}
\alias{plot.power.bftest}
\title{Plot method for class \code{"power.bftest"}}
\usage{
\method{plot}{power.bftest}(
  x,
  nlim = c(2, 500),
  ngrid = 100,
  type = "l",
  plot = TRUE,
  nullplot = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{"power.bftest"}}

\item{nlim}{Range of sample sizes over which the power should be computed.
Defaults to \code{c(2, 500)}}

\item{ngrid}{Number of grid point for which power should be computed.
Defaults to 100}

\item{type}{Type of plot. Defaults to \code{"l"} (line-plot)}

\item{plot}{Logical indicating whether data should be plotted. If
\code{FALSE} only the data used for plotting are returned.}

\item{nullplot}{Logcal indicating whether a second plot with the power in
favor of the null (using a Bayes factor threshold of 1/k) should be
created. Defaults to \code{TRUE}}

\item{...}{Other arguments (for consistency with the generic)}
}
\value{
Plots power curves (if specified) and invisibly returns a list of
    data frames containing the data underlying the power curves
}
\description{
Plot method for class \code{"power.bftest"}
}
\examples{
ssd1 <- powerbf01(k = 1/6, power = 0.95, pm = 0, psd = 1/sqrt(2), dpm = 0.5, dpsd = 0)
plot(ssd1, nlim = c(1, 8000))

power1 <- powerbf01(k = 1/2, n = 120, pm = 0, psd = 1/sqrt(2), dpm = 0.5, dpsd = 0)
plot(power1, nlim = c(1, 1000))

}
\seealso{
\link{powerbf01}, \link{powertbf01}, \link{powernmbf01}
}
\author{
Samuel Pawel
}
