% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_notices.R
\name{bid_telemetry}
\alias{bid_telemetry}
\title{Concise telemetry analysis with tidy output}
\usage{
bid_telemetry(path, format = NULL, events_table = NULL, thresholds = list())
}
\arguments{
\item{path}{File path to telemetry data (SQLite database or JSON log file)}

\item{format}{Optional format specification ("sqlite" or "json"). If NULL,
auto-detected from file extension.}

\item{events_table}{Optional data.frame specifying custom events table when
reading from SQLite. Must have columns: event_id, timestamp, event_type, user_id.
If NULL, auto-detects standard table names (event_data, events).}

\item{thresholds}{Optional list of threshold parameters:
- unused_input_threshold: percentage of sessions below which input is
considered unused (default: 0.05)
- delay_threshold_secs: seconds of delay considered problematic
(default: 30)
- error_rate_threshold: percentage of sessions with errors considered
problematic (default: 0.1)
- navigation_threshold: percentage of sessions visiting a page below
which it's considered underused (default: 0.2)
- rapid_change_window: seconds within which multiple changes indicate
confusion (default: 10)
- rapid_change_count: number of changes within window to flag as
confusion (default: 5)}
}
\value{
A tibble of class "bid_issues_tbl" with structured issue metadata
}
\description{
Preferred modern interface for telemetry analysis. Returns a clean tibble
of identified issues without the legacy list structure. Use this function
for new workflows that don't need backward compatibility.
}
\examples{
\dontrun{
# Modern workflow
issues <- bid_telemetry("telemetry.sqlite")
high_priority <- issues[issues$severity \%in\% c("critical", "high"), ]

# Use with bridges for BID workflow
top_issue <- issues[1, ]
notice <- bid_notice_issue(top_issue, previous_stage = interpret_stage)
}
}
