% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.big_pls_cox.R
\name{cv.big_pls_cox}
\alias{cv.big_pls_cox}
\alias{cv.big_pls_cox_gd}
\title{Cross-validation for big-memory PLS-Cox models}
\usage{
cv.big_pls_cox(
  data,
  nfold = 5L,
  nt = 5L,
  keepX = NULL,
  givefold,
  allCVcrit = FALSE,
  times.auc = NULL,
  times.prederr = NULL,
  method = c("efron", "breslow"),
  verbose = TRUE,
  ...
)

cv.big_pls_cox_gd(
  data,
  nfold = 5L,
  nt = NULL,
  keepX = NULL,
  givefold,
  allCVcrit = FALSE,
  times.auc = NULL,
  times.prederr = NULL,
  method = c("efron", "breslow"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A list with entries \code{x}, \code{time} and \code{status} matching the
arguments of \code{\link[=big_pls_cox]{big_pls_cox()}} or \code{\link[=big_pls_cox_gd]{big_pls_cox_gd()}}. \code{x} can be either a
numeric matrix/data frame or a \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}}.}

\item{nfold}{Integer giving the number of folds to use.}

\item{nt}{Number of latent components to evaluate.}

\item{keepX}{Optional integer vector passed to the modelling function to
enforce naive sparsity (see \code{\link[=big_pls_cox]{big_pls_cox()}}).}

\item{givefold}{Optional list of fold indices. When supplied, it must contain
\code{nfold} integer vectors whose union is \code{seq_len(nrow(data$x))}.}

\item{allCVcrit}{Logical; when \code{FALSE} (default) only the recommended
integrated AUC computed with \pkg{survivalROC} is returned. When \code{TRUE}, the
13 additional criteria from \pkg{plsRcox} are also evaluated.}

\item{times.auc}{Optional time grid used for time-dependent AUC computations.
Defaults to an equally spaced grid between zero and the maximum observed
time.}

\item{times.prederr}{Optional time grid used for prediction error curves.
Defaults to the same grid as \code{times.auc} without the last ten evaluation
points to avoid instabilities.}

\item{method}{Ties handling method passed to \code{\link[survival:coxph]{survival::coxph}}.}

\item{verbose}{Logical; print progress information.}

\item{...}{Additional arguments forwarded to the underlying modelling
function.}
}
\value{
A list containing cross-validation summaries. When \code{allCVcrit = FALSE}, the list holds
\item{\code{nt}}{Number of components assessed.}
\item{\code{cv.error10}}{Mean iAUC of \pkg{survivalROC} across folds for 0 to
\code{nt} components.}
\item{\code{cv.se10}}{Estimated standard errors for \code{cv.error10}.}
\item{\code{folds}}{Fold assignments.}
\item{\code{lambda.min10}}{Component minimising the cross-validated error.}
\item{\code{lambda.1se10}}{Largest component within one standard error of the
optimum.}
When \code{allCVcrit = TRUE}, the full set of 14 criteria (log partial
likelihood, iAUC variants and Brier scores) is returned together with their
associated standard errors and one-standard-error selections.
}
\description{
Performs K-fold cross-validation for models fitted with
\code{\link[=big_pls_cox]{big_pls_cox()}} or \code{\link[=big_pls_cox_gd]{big_pls_cox_gd()}}. The routine mirrors the behaviour of
the cross-validation helpers available in the original \pkg{plsRcox}
package while operating on \code{big.matrix} inputs.
}
\details{
The function returns cross-validated estimates for each component
(including the null model) using either \code{\link[=big_pls_cox]{big_pls_cox()}} or
\code{\link[=big_pls_cox_gd]{big_pls_cox_gd()}}, depending on the \code{engine} argument. The implementation
reuses the internal indicators (\code{getIndicCV}, \code{getIndicCViAUCSurvROCTest})
to provide consistent metrics with the legacy \pkg{plsRcox} helpers.
}
