% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeplink.R
\name{snp_writeBed}
\alias{snp_writeBed}
\title{Write PLINK files from a "bigSNP"}
\usage{
snp_writeBed(x, bedfile, ind.row = rows_along(G), ind.col = cols_along(G))
}
\arguments{
\item{x}{A \link[=bigSNP-class]{bigSNP}.}

\item{bedfile}{Path to file with extension ".bed" to create.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}
}
\value{
The input \code{bedfile} path.
}
\description{
Function to write bed/bim/fam files from a \link[=bigSNP-class]{bigSNP}.
This will use the slot \code{code} \strong{rounded} to write 0s, 1s, 2s or NAs.
}
\examples{
N <- 17
M <- 911

fake <- snp_fake(N, M)
G <- fake$genotypes
G[] <- sample(as.raw(0:3), size = length(G), replace = TRUE)

# Write the object as a bed/bim/fam object
tmp <- tempfile(fileext = ".bed")
bed <- snp_writeBed(fake, tmp)

# Read this new file for the first time
rds <- snp_readBed(bed, backingfile = tempfile())
# Attach object in R session
fake2 <- snp_attach(rds)

# Same content
all.equal(fake$genotypes[], fake2$genotypes[])
all.equal(fake$fam, fake2$fam)
all.equal(fake$map, fake2$map)

# Two different backingfiles
fake$genotypes$backingfile
fake2$genotypes$backingfile
}
