## ---- echo = FALSE, message = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # install myTAI
#  install.packages("myTAI")
#  
#  # load myTAI
#  library(myTAI)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(readxl)
#  
#  # read expression data (organ specific genes) from Sestak and Domazet-Loso, 2015
#  Drerio.OrganSpecificExpression <- read_excel("MBE_2015a_Drerio_PhyloMap.xlsx", sheet = 2, skip = 3)
#  
#  # select only brain specific genes
#  Drerio.Brain.Genes <- unlist(unique(na.omit(Drerio.OrganSpecificExpression[ , "brain"])))
#  
#  # visualize enriched Phylostrata of genes annotated as brain specific
#  PlotEnrichment(Drerio.PhyloMap,
#                 test.set     = Drerio.Brain.Genes,
#                 measure      = "foldchange",
#                 use.only.map = TRUE,
#                 legendName   = "PS")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  BrainGenes <- SelectGeneSet(ExpressionSet = Drerio.PhyloMap,
#                              gene.set      = Drerio.Brain.Genes,
#                              use.only.map  = TRUE)
#  
#  # select only brain genes originating in PS5
#  BrainGenes.PS5 <- BrainGenes[which(BrainGenes[ , "Phylostrata"] == 5), ]
#  
#  # look at the results
#  head(BrainGenes.PS5)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # find filter for zfin.org ids
#  organismFilters("Danio rerio", topic = "zfin_id")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # find go attribute term for D. rerio
#  organismAttributes("Danio rerio", topic = "go")

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieve GO terms of D. rerio brain genes originating in PS5
#  GO_tbl.BrainGenes <- biomart(genes      = unlist(BrainGenes.PS5[ , "ZFIN_ID"]),
#                               mart       = "ENSEMBL_MART_ENSEMBL",
#                               dataset    = "drerio_gene_ensembl",
#                               attributes = "go_id",
#                               filters    = "zfin_id")
#  
#  head(GO_tbl.BrainGenes)

