% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeDataBiometrics.r
\docType{data}
\name{trlpsptime}
\alias{trlpsptime}
\title{Long term tree-list data from permanent sample plots}
\format{
Contains tree-level variables, as follows:
\describe{
  \item{plot}{Plot number.}
  \item{tree}{Tree identificator.}
  \item{species}{Species code as follows:
  PCAB=Picea abies, LADC=Larix decidua, PNSY=Pinus sylvestris, 
  FASY=Fagus Sylvatica, QCPE=Quercus petraea, BTPE=Betula pendula.}
  \item{year}{Year of measurement.}
  \item{obs}{Observation.}
 \item{dbh}{Diameter at breast-height, in mm.}
 \item{dbh2}{Orthogonal measured second diameter, in mm.}
 \item{hmk}{Selection criteria to measure tree height. 
 1=systematic, 2=systematic and in the group of the 100 thickest, 
 3=belongs to the 100 thickest, 4=lying tree, 5:Standing tree with a ladder,
 6=outlier, 7=from stem analysis.}
 \item{kh}{Type of the height measurement. 0:tree height, 
 1:angle and distances.}
 \item{ho}{Tree height in dm when kh=0. When kh=1 then distance to the tree
  in dm or in 1977 length of the base bar in cm.}
 \item{ka}{Height to the crown base in dm when kh=0. When kh=1 then angle 
 to the tree top in 1/10 degree.}
 \item{kb}{Crown width in dm when kh=0. When kh=1 then angle to 1.3 m 
 above tree base in 1/10 degree.}
 \item{wka}{Angle to crown base in 1/10 degree.}
 \item{crown.cl}{Crown class according to Kraft. 1=predominant, 
 2=dominant, 3=co-dominant, 4=dominated, 5=overtopped.}
 \item{crown}{Crown quality. 0=normal, 1=broken in the crown region, 
 2=substituted tree top, 3=forked, 4=bushy, stork nest, witches' broom, 
 5=wizen tree top, 6=again broken tree top.}
 \item{stem}{Stem quality. 0=typical, 1=crooked, 2=abiotic damaged, 
 3=biotic damaged, 4=forked stem without damage, 5=forked stem with damage, 
 6=up to 1/3 of the girth is peeled, 
 7=more than 1/3 of the girth is peeled, 
 8=broken stem, 9=other stem damages.}
 \item{defoliation}{crown defoliation. 1=low, 2=medium, 3=much.}
 }
}
\source{
The Austrian Research Center for Forests established a spacing experiment
 with Norway spruce (Picea abies) in the Vienna Woods. In the 'Hauersteig' 
 experiment, several tree-level variables were measured within four sample 
 plots over time.
Data were retrieved from the paper cited below, where several details 
might be worth reading.
}
\usage{
data(trlpsptime)
}
\description{
Temporal tree-level data within four sample plots
 in an experimental forest in Austria. The dataframe contains several
tree-level variables. Plot sizes are 2500 m\eqn{^{2}}{^2} (approx.) 
and the current dataframe only keeps the measurement years having
 a more reliable amount of records.
}
\examples{
data(trlpsptime)
df<-trlpsptime    
head(df) 
tapply(df$dbh, list(df$year,df$plot), mean)
}
\references{
- Kindermann G. Kristofel F, Neumann M, Rossler G, Ledermann T & Schueler. 
2018. 109 years  of forest growth measurements from individual Norway
 spruce trees. Sci. Data 5:180077 \doi{10.1038/sdata.2018.77}
}
\keyword{datasets}
