% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changePixelColor.R
\name{changePixelColor}
\alias{changePixelColor}
\title{Change the color of pixels}
\usage{
changePixelColor(img, coords, color = "purple", visualize = FALSE)
}
\arguments{
\item{img}{image (import by \code{\link[imager]{load.image}})}

\item{coords}{coordinates specifying which pixels to be colored (should
be a X|Y Data frame (first column: X; second column: Y)).}

\item{color}{color with which to replace specified pixels. can be either a
an RGB triplet or one of the colors listed by \code{\link[grDevices]{colors}}.}

\item{visualize}{if TRUE the resulting image gets plotted}
}
\value{
cimg with changed colors at desired positions and plot of the cimg
}
\description{
Can be used to change the color of specified pixels in an image. The coordinates
of the pixels are needed to colorize them.
}
\examples{
coordinates <- objectDetection(beads)
changePixelColor(beads, coordinates$coordinates)
}
\references{
https://CRAN.R-project.org/package=countcolors
}
