% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_data.R
\name{preprocess_data}
\alias{preprocess_data}
\title{Preprocesses time-series data for fitting}
\usage{
preprocess_data(
  data,
  state,
  duration = NULL,
  onset = NULL,
  random_effect = NULL,
  session = NULL,
  run = NULL
)
}
\arguments{
\item{data}{A table with one or many time-series.}

\item{state}{String, the name of the column that specifies
perceptual state. The column type should be a factor with
two or three levels (the third level is assumed to correspond to a
transition/mixed phase) or should be convertible to a two level
factor (as it would be impossible to infer the identity of transition/
mixed phase).}

\item{duration}{String, name of the column with duration of individual
perceptual dominance phases. Optional, you can specify \code{onset}
instead.}

\item{onset}{String, name of the column with onsets of the perceptual
dominance states. Optional, used to compute duration of the dominance
phases, if these are not provided explicitly via \code{duration}
parameter.}

\item{random_effect}{String, name of the column that identifies random effect,
e.g. individual participants, stimuli for a single participant, etc.
If omitted, no random effect is assumed. If specified and
there is more than one level (participant, stimulus, etc.), it is used
in a hierarchical model.}

\item{session}{String, name of the column that identifies unique
experimental session for which a mean dominance phase duration will
be computed (see \code{norm_tau} parameter). Code assumes that session
IDs are different within a participant but can be the same between them.
If omitted, a single mean dominance duration based on the entire time series
is used.}

\item{run}{String, name of the column that identifies unique runs/blocks.
If omitted, the data is assumed to belong to a single time series. Code
assumes that run IDs are different within an experimental session but
can be the same between the session. E.g. session A, runs 1, 2, 3.. and
session B, runs 1, 2, 3 but not session A, runs 1, 2, 1.}
}
\value{
A tibble with columns
\itemize{
\item \code{state}
\item \code{duration}
\item \code{random}
\item \code{irandom} - integer, index of \code{random} values,
\item \code{session}
\item \code{run}
\item \code{session_tmean} - numeric, mean duration of clear percepts for every combination of \code{random} and \code{session}.
\item \code{is_used} - integer, whether computed history value needs to be used for linear model fitting.
\item \code{run_start} - integer, 1 for the first row of the run time-series.
}
}
\description{
Performs sanity checks (e.g., whether \code{data} can be used as a data.frame),
computes duration of dominance phases (if necessary), assumes a single entry for
any missing \code{session}, \code{run}, \code{random_effect}.
}
\examples{
df <- preprocess_data(br_singleblock, state="State", duration="Duration")
}
